/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.waimai.router.fragment.v4;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import com.sankuai.waimai.router.core.Debugger;
import com.sankuai.waimai.router.core.UriRequest;
import com.sankuai.waimai.router.fragment.AbsFragmentUriRequest;
import com.sankuai.waimai.router.fragment.StartFragmentAction;

public class FragmentBuildUriRequest
extends AbsFragmentUriRequest {
    public static final String FRAGMENT = "CUSTOM_FRAGMENT_OBJ";

    public FragmentBuildUriRequest(@NonNull Context context, String uri) {
        super(context, uri);
    }

    @Override
    protected StartFragmentAction getStartFragmentAction() {
        return new StartFragmentAction(){

            @Override
            public boolean startFragment(@NonNull UriRequest request, @NonNull Bundle bundle) throws ActivityNotFoundException, SecurityException {
                String fragmentClassName = request.getStringField("FRAGMENT_CLASS_NAME");
                if (TextUtils.isEmpty((CharSequence)fragmentClassName)) {
                    Debugger.fatal("FragmentBuildUriRequest.handleInternal()\u5e94\u8fd4\u56de\u7684\u5e26\u6709ClassName", new Object[0]);
                    return false;
                }
                try {
                    Fragment fragment = Fragment.instantiate((Context)request.getContext(), (String)fragmentClassName, (Bundle)bundle);
                    if (fragment == null) {
                        return false;
                    }
                    request.putField(FragmentBuildUriRequest.FRAGMENT, fragment);
                    return true;
                }
                catch (Exception e) {
                    Debugger.e(e);
                    return false;
                }
            }
        };
    }
}

