/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.waimai.router.core;

import androidx.annotation.NonNull;
import com.sankuai.waimai.router.core.Debugger;
import com.sankuai.waimai.router.core.UriCallback;
import com.sankuai.waimai.router.core.UriInterceptor;
import com.sankuai.waimai.router.core.UriRequest;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ChainedInterceptor
implements UriInterceptor {
    private final List<UriInterceptor> mInterceptors = new LinkedList<UriInterceptor>();

    public void addInterceptor(@NonNull UriInterceptor interceptor) {
        if (interceptor != null) {
            this.mInterceptors.add(interceptor);
        }
    }

    @Override
    public void intercept(@NonNull UriRequest request, @NonNull UriCallback callback) {
        this.next(this.mInterceptors.iterator(), request, callback);
    }

    private void next(final @NonNull Iterator<UriInterceptor> iterator, final @NonNull UriRequest request, final @NonNull UriCallback callback) {
        if (iterator.hasNext()) {
            UriInterceptor t = iterator.next();
            if (Debugger.isEnableLog()) {
                Debugger.i("    %s: intercept, request = %s", t.getClass().getSimpleName(), request);
            }
            t.intercept(request, new UriCallback(){

                @Override
                public void onNext() {
                    ChainedInterceptor.this.next(iterator, request, callback);
                }

                @Override
                public void onComplete(int resultCode) {
                    callback.onComplete(resultCode);
                }
            });
        } else {
            callback.onNext();
        }
    }
}

