/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.waimai.router.core;

import androidx.annotation.NonNull;
import com.sankuai.waimai.router.core.UriCallback;
import com.sankuai.waimai.router.core.UriHandler;
import com.sankuai.waimai.router.core.UriRequest;
import com.sankuai.waimai.router.utils.PriorityList;
import java.util.Iterator;
import java.util.List;

public class ChainedHandler
extends UriHandler {
    private final PriorityList<UriHandler> mHandlers = new PriorityList();

    public ChainedHandler addChildHandler(@NonNull UriHandler handler, int priority) {
        this.mHandlers.addItem(handler, priority);
        return this;
    }

    public ChainedHandler addChildHandler(@NonNull UriHandler handler) {
        return this.addChildHandler(handler, 0);
    }

    @NonNull
    protected List<UriHandler> getHandlers() {
        return this.mHandlers;
    }

    @Override
    protected boolean shouldHandle(@NonNull UriRequest request) {
        return !this.mHandlers.isEmpty();
    }

    @Override
    protected void handleInternal(@NonNull UriRequest request, @NonNull UriCallback callback) {
        this.next(this.mHandlers.iterator(), request, callback);
    }

    private void next(final @NonNull Iterator<UriHandler> iterator, final @NonNull UriRequest request, final @NonNull UriCallback callback) {
        if (iterator.hasNext()) {
            UriHandler t = iterator.next();
            t.handle(request, new UriCallback(){

                @Override
                public void onNext() {
                    ChainedHandler.this.next(iterator, request, callback);
                }

                @Override
                public void onComplete(int resultCode) {
                    callback.onComplete(resultCode);
                }
            });
        } else {
            callback.onNext();
        }
    }
}

