/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.waimai.router.components;

import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import com.sankuai.waimai.router.core.Debugger;
import com.sankuai.waimai.router.core.UriRequest;

public class UriSourceTools {
    public static final int FROM_INVALID = 0;
    public static final int FROM_EXTERNAL = 1;
    public static final int FROM_INTERNAL = 2;
    public static final int FROM_WEBVIEW = 3;
    public static final int FROM_PUSH = 4;
    public static final String FIELD_FROM = "com.sankuai.waimai.router.from";
    public static final String INTENT_KEY_URI_FROM = "com.sankuai.waimai.router.from";
    public static boolean sDisableExportedControl = false;

    public static void setDisableExportedControl(boolean disableExportedControl) {
        sDisableExportedControl = disableExportedControl;
    }

    public static boolean shouldHandle(UriRequest request, boolean exported) {
        return sDisableExportedControl || exported || UriSourceTools.getSource(request) != 1;
    }

    public static void setSource(UriRequest request, int from) {
        if (request != null) {
            request.putField("com.sankuai.waimai.router.from", from);
        }
    }

    public static int getSource(@NonNull UriRequest request) {
        return UriSourceTools.getSource(request, 2);
    }

    public static int getSource(@NonNull UriRequest request, int defaultValue) {
        return request.getIntField("com.sankuai.waimai.router.from", defaultValue);
    }

    public static void setIntentSource(Intent intent, UriRequest request) {
        Integer result;
        if (intent != null && request != null && (result = request.getField(Integer.class, "com.sankuai.waimai.router.from")) != null) {
            UriSourceTools.setSource(intent, (int)result);
        }
    }

    public static void setSource(Intent intent, int source) {
        if (intent != null) {
            intent.putExtra("com.sankuai.waimai.router.from", source);
        }
    }

    public static int getSource(Intent intent, int defaultValue) {
        return UriSourceTools.getInt(intent, "com.sankuai.waimai.router.from", defaultValue);
    }

    public static int getSource(Bundle bundle, int defaultValue) {
        return bundle == null ? defaultValue : bundle.getInt("com.sankuai.waimai.router.from", defaultValue);
    }

    private static int getInt(Intent intent, String key, int defaultValue) {
        if (intent == null) {
            return defaultValue;
        }
        try {
            return intent.getIntExtra(key, defaultValue);
        }
        catch (Exception e) {
            Debugger.fatal(e);
            return defaultValue;
        }
    }
}

