/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.android.service;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.util.Log;
import androidx.lifecycle.LifecycleOwner;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import org.eclipse.paho.android.service.AlarmWorker;
import org.eclipse.paho.android.service.MqttService;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttPingSender;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;

class AlarmPingSender
implements MqttPingSender {
    private static final String TAG = "AlarmPingSender";
    private ClientComms comms;
    private MqttService service;
    private BroadcastReceiver alarmReceiver;
    private AlarmPingSender that;
    private PendingIntent pendingIntent;
    private volatile boolean hasStarted = false;

    public AlarmPingSender(MqttService service) {
        if (service == null) {
            throw new IllegalArgumentException("Neither service nor client can be null.");
        }
        this.service = service;
        this.that = this;
    }

    public void init(ClientComms comms) {
        this.comms = comms;
        this.alarmReceiver = new AlarmReceiver();
    }

    public void start() {
        String action = "MqttService.pingSender." + this.comms.getClient().getClientId();
        Log.d((String)TAG, (String)("Register alarmreceiver to MqttService" + action));
        IntentFilter filter = new IntentFilter(action);
        if (Build.VERSION.SDK_INT >= 33) {
            this.service.registerReceiver(this.alarmReceiver, filter, 2);
        } else {
            this.service.registerReceiver(this.alarmReceiver, filter);
        }
        this.pendingIntent = Build.VERSION.SDK_INT >= 31 ? PendingIntent.getBroadcast((Context)this.service, (int)0, (Intent)new Intent(action), (int)0x4000000) : PendingIntent.getBroadcast((Context)this.service, (int)0, (Intent)new Intent(action), (int)0x8000000);
        this.schedule(this.comms.getKeepAlive());
        this.hasStarted = true;
    }

    public void stop() {
        Log.d((String)TAG, (String)("Unregister alarmreceiver to MqttService" + this.comms.getClient().getClientId()));
        if (this.hasStarted) {
            if (this.pendingIntent != null) {
                WorkManager.getInstance((Context)this.that.service).cancelAllWorkByTag("AlarmWorkerTAG");
            }
            this.hasStarted = false;
            try {
                this.service.unregisterReceiver(this.alarmReceiver);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void schedule(long delayInMilliseconds) {
        long nextAlarmInMilliseconds = System.currentTimeMillis() + delayInMilliseconds;
        Log.d((String)TAG, (String)("Schedule next alarm at " + nextAlarmInMilliseconds));
        Log.d((String)TAG, (String)("Alarm scheule using setExactAndAllowWhileIdle, next: " + delayInMilliseconds));
        Log.d((String)TAG, (String)("Alarm scheule using setExact, delay: " + delayInMilliseconds));
        String action = "MqttService.pingSender." + this.comms.getClient().getClientId();
        Intent intent = new Intent(action);
        this.that.service.sendBroadcast(intent);
    }

    class AlarmReceiver
    extends BroadcastReceiver {
        private final String wakeLockTag;

        AlarmReceiver() {
            this.wakeLockTag = "MqttService.client." + AlarmPingSender.this.that.comms.getClient().getClientId();
        }

        @SuppressLint(value={"Wakelock"})
        public void onReceive(Context context, Intent intent) {
            Log.d((String)AlarmPingSender.TAG, (String)("Sending Ping at:" + System.currentTimeMillis() + intent.getAction()));
            final OneTimeWorkRequest workRequest = (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(AlarmWorker.class).addTag("AlarmWorkerTAG")).build();
            WorkManager.getInstance((Context)AlarmPingSender.this.that.service).enqueue((WorkRequest)workRequest);
            WorkManager.getInstance((Context)AlarmPingSender.this.that.service).getWorkInfoByIdLiveData(workRequest.getId()).observe((LifecycleOwner)AlarmPingSender.this.that.service, workInfo -> {
                if (workInfo != null && workInfo.getState().isFinished()) {
                    Log.d((String)AlarmPingSender.TAG, (String)("Ping finished. Release lock(" + this.wakeLockTag + ")"));
                    MqttToken mqttToken = AlarmPingSender.this.comms.checkForActivity(new IMqttActionListener(){

                        public void onSuccess(IMqttToken asyncActionToken) {
                            Log.d((String)AlarmPingSender.TAG, (String)("Success. Release lock(" + AlarmReceiver.this.wakeLockTag + "):" + System.currentTimeMillis()));
                            WorkManager.getInstance((Context)AlarmPingSender.this.that.service).cancelWorkById(workRequest.getId());
                        }

                        public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                            Log.d((String)AlarmPingSender.TAG, (String)("Failure. Release lock(" + AlarmReceiver.this.wakeLockTag + "):" + System.currentTimeMillis()));
                            WorkManager.getInstance((Context)AlarmPingSender.this.that.service).cancelWorkById(workRequest.getId());
                        }
                    });
                }
            });
        }
    }
}

