/*
 * Decompiled with CFR 0.152.
 */
package io.github.mavi.kover.plugin;

import com.intellij.rt.coverage.verify.Verifier;
import com.intellij.rt.coverage.verify.api.Bound;
import com.intellij.rt.coverage.verify.api.BoundViolation;
import com.intellij.rt.coverage.verify.api.Counter;
import com.intellij.rt.coverage.verify.api.Rule;
import com.intellij.rt.coverage.verify.api.RuleViolation;
import com.intellij.rt.coverage.verify.api.Target;
import com.intellij.rt.coverage.verify.api.ValueType;
import com.intellij.rt.coverage.verify.api.VerificationApi;
import com.intellij.rt.coverage.verify.api.Violation;
import io.github.mavi.kover.plugin.AbstractKoverMojo;
import io.github.mavi.kover.plugin.AggregationGroup;
import io.github.mavi.kover.plugin.AggregationType;
import io.github.mavi.kover.plugin.BoundViolations;
import io.github.mavi.kover.plugin.MetricType;
import io.github.mavi.kover.plugin.ProjectExtensionsKt;
import io.github.mavi.kover.plugin.RuleViolations;
import io.github.mavi.kover.plugin.VerificationRule;
import io.github.mavi.kover.plugin.VerifyMojo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 .2\u00020\u0001:\u0001.B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u00102\u0006\u0010\b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u000eH\u0002J\r\u0010\u0016\u001a\u00020\u0017H\u0010\u00a2\u0006\u0002\b\u0018J\u0016\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0010H\u0002J.\u0010\u001d\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u001e0\u00102\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u0010H\u0002J\u0016\u0010!\u001a\u00020\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\"0\u0010H\u0002J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u0005H\u0002J\b\u0010$\u001a\u00020\u0017H\u0002J\b\u0010%\u001a\u00020\u0017H\u0002J\f\u0010&\u001a\u00020'*\u00020\u0005H\u0002J\f\u0010(\u001a\u00020\u001a*\u00020\tH\u0002J\u0018\u0010)\u001a\u0004\u0018\u00010**\u00020\u00052\b\u0010+\u001a\u0004\u0018\u00010\u001aH\u0002J\f\u0010,\u001a\u00020-*\u00020\u0005H\u0002R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006/"}, d2={"Lio/github/mavi/kover/plugin/VerifyMojo;", "Lio/github/mavi/kover/plugin/AbstractKoverMojo;", "()V", "rules", "", "Lio/github/mavi/kover/plugin/VerificationRule;", "getRules$kover_maven_plugin", "()Ljava/util/List;", "boundViolation", "Lio/github/mavi/kover/plugin/BoundViolations;", "violation", "Lcom/intellij/rt/coverage/verify/api/Violation;", "rule", "isMax", "", "boundViolations", "", "Lcom/intellij/rt/coverage/verify/api/BoundViolation;", "bound", "ruleIndex", "", "canExecute", "executeMojo", "", "executeMojo$kover_maven_plugin", "generateErrorMessage", "", "violations", "Lio/github/mavi/kover/plugin/RuleViolations;", "groupRules", "Lkotlin/Pair;", "Lio/github/mavi/kover/plugin/AggregationGroup;", "aggregationGroups", "processViolations", "Lcom/intellij/rt/coverage/verify/api/RuleViolation;", "validateNumbers", "validateRules", "verifyCoverage", "counterToReporter", "Lcom/intellij/rt/coverage/verify/api/Counter;", "format", "valueToReporter", "Ljava/math/BigDecimal;", "value", "valueTypeToReporter", "Lcom/intellij/rt/coverage/verify/api/ValueType;", "Companion", "kover-maven-plugin"})
@Mojo(name="verify", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
@SourceDebugExtension(value={"SMAP\nVerifyMojo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VerifyMojo.kt\nio/github/mavi/kover/plugin/VerifyMojo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,278:1\n1855#2:279\n2624#2,3:280\n2624#2,3:283\n1856#2:286\n1559#2:287\n1590#2,4:288\n1194#2,2:292\n1222#2,4:294\n1549#2:298\n1620#2,3:299\n1549#2:302\n1620#2,2:303\n1559#2:305\n1590#2,4:306\n1179#2,2:310\n1253#2,4:312\n1360#2:316\n1446#2,5:317\n1622#2:322\n1549#2:323\n1620#2,3:324\n1549#2:327\n1620#2,3:328\n1855#2:332\n1855#2,2:333\n1856#2:335\n1#3:331\n*S KotlinDebug\n*F\n+ 1 VerifyMojo.kt\nio/github/mavi/kover/plugin/VerifyMojo\n*L\n44#1:279\n45#1:280,3\n51#1:283,3\n44#1:286\n95#1:287\n95#1:288,4\n116#1:292,2\n116#1:294,4\n116#1:298\n116#1:299,3\n120#1:302\n120#1:303,2\n122#1:305\n122#1:306,4\n122#1:310,2\n122#1:312,4\n128#1:316\n128#1:317,5\n120#1:322\n149#1:323\n149#1:324,3\n159#1:327\n159#1:328,3\n194#1:332\n202#1:333,2\n194#1:335\n*E\n"})
public final class VerifyMojo
extends AbstractKoverMojo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Parameter
    @NotNull
    private final List<VerificationRule> rules = new ArrayList();
    @NotNull
    private static final BigDecimal ONE_HUNDRED;
    private static final int scale = 6;
    @NotNull
    private static final BigDecimal maxPercentage;

    @NotNull
    public final List<VerificationRule> getRules$kover_maven_plugin() {
        return this.rules;
    }

    @Override
    public void executeMojo$kover_maven_plugin() {
        if (!this.canExecute()) {
            this.getLog().info((CharSequence)"Skipping Kover execution because no report file was found.");
            return;
        }
        if (this.rules.isEmpty()) {
            this.getLog().warn((CharSequence)"Skipping Kover verification because no rules are defined.");
            return;
        }
        this.validateRules();
        this.verifyCoverage();
    }

    private final boolean canExecute() {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.exists(ProjectExtensionsKt.instrumentation(this.getProject$kover_maven_plugin()), Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    private final void validateRules() {
        Iterable $this$forEach$iv = this.rules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            VerificationRule rule;
            block13: {
                Enum it;
                boolean $i$f$none;
                Iterable $this$none$iv;
                block15: {
                    block14: {
                        boolean bl2;
                        block12: {
                            rule = (VerificationRule)element$iv;
                            boolean bl3 = false;
                            if (rule.getMetric() == null) break block14;
                            $this$none$iv = (Iterable)MetricType.getEntries();
                            $i$f$none = false;
                            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                bl2 = true;
                            } else {
                                for (Object element$iv2 : $this$none$iv) {
                                    it = (MetricType)((Object)element$iv2);
                                    boolean bl4 = false;
                                    if (!(rule.getMetric() == it)) continue;
                                    bl2 = false;
                                    break block12;
                                }
                                bl2 = true;
                            }
                        }
                        if (!bl2) break block15;
                    }
                    throw new MojoExecutionException("A rule needs to define a (valid) type of metric. Valid options: " + CollectionsKt.joinToString$default((Iterable)((Iterable)MetricType.getEntries()), (CharSequence)", ", null, null, (int)0, null, (Function1)validateRules.1.2.INSTANCE, (int)30, null) + ".");
                }
                $this$none$iv = (Iterable)AggregationType.getEntries();
                $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv2 : $this$none$iv) {
                        it = (AggregationType)((Object)element$iv2);
                        boolean bl5 = false;
                        if (!(rule.getAggregation() == it)) continue;
                        bl = false;
                        break block13;
                    }
                    bl = true;
                }
            }
            if (bl) {
                throw new MojoExecutionException("Invalid aggregation type '" + rule.getAggregation() + "' detected. Valid options: " + CollectionsKt.joinToString$default((Iterable)((Iterable)AggregationType.getEntries()), (CharSequence)", ", null, null, (int)0, null, (Function1)validateRules.1.4.INSTANCE, (int)30, null) + ".");
            }
            this.validateNumbers(rule);
        }
    }

    private final void validateNumbers(VerificationRule rule) {
        if (!(rule.getMinValue() == null || NumberUtils.isParsable((String)rule.getMinValue()) && new BigDecimal(rule.getMinValue()).signum() != -1)) {
            throw new MojoExecutionException("'minValue' needs to be (positive) number");
        }
        if (!(rule.getMaxValue() == null || NumberUtils.isParsable((String)rule.getMaxValue()) && new BigDecimal(rule.getMaxValue()).signum() != -1)) {
            throw new MojoExecutionException("'maxValue' needs to be (positive) number");
        }
        if (rule.getAggregation().isPercentage()) {
            if (rule.getMinValue() != null && new BigDecimal(rule.getMinValue()).compareTo(maxPercentage) > 0) {
                throw new MojoExecutionException("'minValue' cannot be above 100%");
            }
            if (rule.getMaxValue() != null && new BigDecimal(rule.getMaxValue()).compareTo(maxPercentage) > 0) {
                throw new MojoExecutionException("'maxValue' cannot be above 100%");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyCoverage() {
        List aggregationGroups = CollectionsKt.listOf((Object)new AggregationGroup(ProjectExtensionsKt.aggregationInstrumentation(this.getProject$kover_maven_plugin()), ProjectExtensionsKt.aggregationMap(this.getProject$kover_maven_plugin())));
        List<Pair<AggregationGroup, List<VerificationRule>>> rulesByFilter = this.groupRules(aggregationGroups);
        Iterable iterable = rulesByFilter;
        Collection collection = new ArrayList();
        int n = 0;
        for (Object t : iterable) {
            void $this$mapIndexedTo$iv$iv;
            void pair;
            int n2;
            if ((n2 = n++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pair pair2 = (Pair)t;
            int index = n2;
            boolean bl = false;
            Iterable $this$mapIndexed$iv = (Iterable)pair.getSecond();
            boolean $i$f$mapIndexed = false;
            Iterable iterable2 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void ruleIndex;
                void rule;
                int n3;
                if ((n3 = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                VerificationRule verificationRule = (VerificationRule)item$iv$iv;
                int n4 = n3;
                Collection collection2 = destination$iv$iv;
                boolean bl2 = false;
                AggregationGroup group = (AggregationGroup)pair.getFirst();
                Bound bound = new Bound(index, this.counterToReporter((VerificationRule)rule), this.valueTypeToReporter((VerificationRule)rule), this.valueToReporter((VerificationRule)rule, rule.getMinValue()), this.valueToReporter((VerificationRule)rule, rule.getMaxValue()));
                collection2.add(new Rule((int)ruleIndex, group.getIc().toFile(), Target.ALL, CollectionsKt.listOf((Object)bound)));
            }
            CollectionsKt.addAll((Collection)collection, (Iterable)((List)destination$iv$iv));
        }
        List rulesArray = (List)collection;
        Verifier verifier = new Verifier(rulesArray);
        verifier.processRules();
        List violations = VerificationApi.verify((List)rulesArray);
        Intrinsics.checkNotNull((Object)violations);
        this.processViolations(violations);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<AggregationGroup, List<VerificationRule>>> groupRules(List<AggregationGroup> aggregationGroups) {
        void $this$mapTo$iv$iv;
        Object object;
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = aggregationGroups;
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            AggregationGroup aggregationGroup = (AggregationGroup)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.put(it, element$iv$iv);
        }
        Iterable $this$map$iv = destination$iv$iv.entrySet();
        boolean $i$f$map = false;
        Iterable capacity$iv22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object element$iv$iv;
            element$iv$iv = (Map.Entry)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            object.add(TuplesKt.to(it.getKey(), this.rules));
        }
        return (List)destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private final void processViolations(List<? extends RuleViolation> violations) {
        Object object;
        Object object2 = this;
        try {
            void $this$mapTo$iv$iv;
            VerifyMojo $this$processViolations_u24lambda_u2411 = object2;
            boolean bl = false;
            Iterable $this$map$iv = violations;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$flatMapTo$iv$iv;
                Iterable $this$associateTo$iv$iv;
                void $this$associate$iv;
                void $this$mapIndexedTo$iv$iv;
                void violation;
                RuleViolation ruleViolation = (RuleViolation)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                int ruleIndex = violation.id;
                Iterable $this$mapIndexed$iv = $this$processViolations_u24lambda_u2411.rules;
                boolean $i$f$mapIndexed = false;
                Iterable iterable2 = $this$mapIndexed$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
                    void rule;
                    void index;
                    int n;
                    if ((n = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    VerificationRule verificationRule = (VerificationRule)item$iv$iv2;
                    int n2 = n;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl3 = false;
                    collection2.add(TuplesKt.to((Object)((int)index), (Object)rule));
                }
                $this$mapIndexed$iv = (List)destination$iv$iv2;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                destination$iv$iv2 = $this$associate$iv;
                Object destination$iv$iv3 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map = destination$iv$iv3;
                    Pair it = (Pair)element$iv$iv;
                    boolean bl4 = false;
                    map.put(it.getFirst(), it.getSecond());
                }
                Object boundsMap = destination$iv$iv3;
                if ((VerificationRule)boundsMap.get(ruleIndex) == null) {
                    throw new MojoExecutionException("Error occurred while parsing verification result: unmapped rule with index " + ruleIndex);
                }
                List list = violation.violations;
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"violations");
                Iterable $this$flatMap$iv = list;
                boolean $i$f$flatMap = false;
                $this$associateTo$iv$iv = $this$flatMap$iv;
                destination$iv$iv3 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    VerificationRule bound;
                    BoundViolation it = (BoundViolation)element$iv$iv;
                    boolean bl5 = false;
                    Intrinsics.checkNotNull((Object)it);
                    Iterable list$iv$iv = $this$processViolations_u24lambda_u2411.boundViolations(it, bound, ruleIndex);
                    CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
                }
                List list2 = (List)destination$iv$iv3;
                collection.add(new RuleViolations(list2));
            }
            object = Result.constructor-impl((Object)((List)destination$iv$iv));
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object it = object = throwable;
            boolean bl = false;
            throw new MojoExecutionException("Error occurred while parsing verifier result", (Throwable)it);
        }
        ResultKt.throwOnFailure((Object)object2);
        List ruleViolations = (List)object2;
        if (!((Collection)ruleViolations).isEmpty()) {
            this.getLog().warn((CharSequence)"Coverage checks have not been met, see log for details");
            throw new MojoExecutionException(this.generateErrorMessage(ruleViolations));
        }
        this.getLog().info((CharSequence)"All coverage checks have been met");
    }

    /*
     * WARNING - void declaration
     */
    private final List<BoundViolations> boundViolations(BoundViolation boundViolation, VerificationRule bound, int ruleIndex) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        int boundIndex = boundViolation.id;
        List list = boundViolation.minViolations;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"minViolations");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Violation violation = (Violation)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            if (bound.getMinValue() == null) {
                throw new MojoExecutionException("Error occurred while parsing verification error: no minimal bound with ID " + boundIndex + " and rule index " + ruleIndex);
            }
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.boundViolation((Violation)it, bound, false));
        }
        List minViolations = (List)destination$iv$iv;
        List list2 = boundViolation.maxViolations;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"maxViolations");
        Iterable $this$map$iv2 = list2;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Violation bl = (Violation)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            if (bound.getMaxValue() == null) {
                throw new MojoExecutionException("Error occurred while parsing verification error: no maximal bound with index " + boundIndex + " and rule index " + ruleIndex);
            }
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.boundViolation((Violation)it, bound, true));
        }
        List maxViolations = (List)destination$iv$iv2;
        return CollectionsKt.plus((Collection)minViolations, (Iterable)maxViolations);
    }

    private final BoundViolations boundViolation(Violation violation, VerificationRule rule, boolean isMax) {
        BigDecimal bigDecimal;
        BigDecimal actual;
        BigDecimal bigDecimal2;
        CharSequence charSequence;
        CharSequence charSequence2 = violation.targetName;
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = null;
        } else {
            charSequence = charSequence2;
        }
        String entityName = (String)charSequence;
        BigDecimal value = violation.targetValue;
        if (rule.getAggregation().isPercentage()) {
            Intrinsics.checkNotNull((Object)value);
            BigDecimal bigDecimal3 = value.multiply(ONE_HUNDRED);
            bigDecimal2 = bigDecimal3;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"this.multiply(other)");
        } else {
            bigDecimal2 = actual = value;
        }
        if (isMax) {
            String string = rule.getMaxValue();
            Intrinsics.checkNotNull((Object)string);
            bigDecimal = new BigDecimal(string);
        } else {
            String string = rule.getMinValue();
            Intrinsics.checkNotNull((Object)string);
            bigDecimal = new BigDecimal(string);
        }
        Intrinsics.checkNotNull((Object)actual);
        MetricType metricType = rule.getMetric();
        Intrinsics.checkNotNull((Object)((Object)metricType));
        return new BoundViolations(isMax, bigDecimal, actual, metricType, rule.getAggregation(), entityName);
    }

    private final String generateErrorMessage(List<RuleViolations> violations) {
        StringBuilder messageBuilder = new StringBuilder();
        Iterable $this$forEach$iv = violations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RuleViolations rule = (RuleViolations)element$iv;
            boolean bl = false;
            String namedRule = "Rule";
            if (rule.getBounds().size() == 1) {
                StringBuilder stringBuilder = messageBuilder.append(namedRule + " violated: " + this.format(rule.getBounds().get(0)));
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
                continue;
            }
            StringBuilder stringBuilder = messageBuilder.append(namedRule + " violated:");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
            Iterable $this$forEach$iv2 = rule.getBounds();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                StringBuilder stringBuilder2;
                BoundViolations it = (BoundViolations)element$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)messageBuilder.append("  "), (String)"append(...)");
                StringBuilder stringBuilder3 = stringBuilder2.append(this.format(it));
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
            }
        }
        String string = messageBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String format(BoundViolations $this$format) {
        String string;
        String string2;
        String directionText = $this$format.isMax() ? "maximum" : "minimum";
        switch (WhenMappings.$EnumSwitchMapping$0[$this$format.getMetric().ordinal()]) {
            case 1: {
                string2 = "lines";
                break;
            }
            case 2: {
                string2 = "instructions";
                break;
            }
            case 3: {
                string2 = "branches";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String metricText = string2;
        switch (WhenMappings.$EnumSwitchMapping$1[$this$format.getAggregation().ordinal()]) {
            case 1: {
                string = "covered count";
                break;
            }
            case 2: {
                string = "missed count";
                break;
            }
            case 3: {
                string = "covered percentage";
                break;
            }
            case 4: {
                string = "missed percentage";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String valueTypeText = string;
        return metricText + " " + valueTypeText + " is " + $this$format.getActualValue() + ", but expected " + directionText + " is " + $this$format.getExpectedValue();
    }

    private final Counter counterToReporter(VerificationRule $this$counterToReporter) {
        Counter counter;
        MetricType metricType = $this$counterToReporter.getMetric();
        Intrinsics.checkNotNull((Object)((Object)metricType));
        switch (WhenMappings.$EnumSwitchMapping$0[metricType.ordinal()]) {
            case 1: {
                counter = Counter.LINE;
                break;
            }
            case 2: {
                counter = Counter.INSTRUCTION;
                break;
            }
            case 3: {
                counter = Counter.BRANCH;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return counter;
    }

    private final ValueType valueTypeToReporter(VerificationRule $this$valueTypeToReporter) {
        ValueType valueType;
        switch (WhenMappings.$EnumSwitchMapping$1[$this$valueTypeToReporter.getAggregation().ordinal()]) {
            case 1: {
                valueType = ValueType.COVERED;
                break;
            }
            case 2: {
                valueType = ValueType.MISSED;
                break;
            }
            case 3: {
                valueType = ValueType.COVERED_RATE;
                break;
            }
            case 4: {
                valueType = ValueType.MISSED_RATE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return valueType;
    }

    private final BigDecimal valueToReporter(VerificationRule $this$valueToReporter, String value) {
        return $this$valueToReporter.getAggregation().isPercentage() ? (value != null ? new BigDecimal(value).divide(ONE_HUNDRED, 6, RoundingMode.HALF_UP) : null) : (value != null ? new BigDecimal(value) : null);
    }

    static {
        BigDecimal bigDecimal = BigDecimal.valueOf(100);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this.toLong())");
        ONE_HUNDRED = bigDecimal;
        maxPercentage = new BigDecimal(100);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/github/mavi/kover/plugin/VerifyMojo$Companion;", "", "()V", "ONE_HUNDRED", "Ljava/math/BigDecimal;", "maxPercentage", "scale", "", "kover-maven-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[MetricType.values().length];
            try {
                nArray[MetricType.LINE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetricType.INSTRUCTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetricType.BRANCH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[AggregationType.values().length];
            try {
                nArray[AggregationType.COVERED_COUNT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AggregationType.MISSED_COUNT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AggregationType.COVERED_PERCENTAGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AggregationType.MISSED_PERCENTAGE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

