/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.ss.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.github.manusant.ss.model.ExternalDocs;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Tag {
    private Map<String, Object> vendorExtensions = new LinkedHashMap<String, Object>();
    private String name;
    private String description;
    private ExternalDocs externalDocs;

    public Tag name(String name) {
        this.setName(name);
        return this;
    }

    public Tag description(String description) {
        this.setDescription(description);
        return this;
    }

    public Tag externalDocs(ExternalDocs externalDocs) {
        this.setExternalDocs(externalDocs);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ExternalDocs getExternalDocs() {
        return this.externalDocs;
    }

    public void setExternalDocs(ExternalDocs externalDocs) {
        this.externalDocs = externalDocs;
    }

    @JsonAnyGetter
    public Map<String, Object> getVendorExtensions() {
        return this.vendorExtensions;
    }

    @JsonAnySetter
    public void setVendorExtension(String name, Object value) {
        if (name.startsWith("x-")) {
            this.vendorExtensions.put(name, value);
        }
    }

    public void setVendorExtensions(Map<String, Object> vendorExtensions) {
        this.vendorExtensions = vendorExtensions;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Tag {\n");
        b.append("\tname: ").append(this.getName()).append("\n");
        b.append("\tdescription: ").append(this.getDescription()).append("\n");
        b.append("\texternalDocs: ").append(this.getExternalDocs()).append("\n");
        b.append("\textensions:").append(this.vendorExtensions.toString());
        b.append("}");
        return b.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.externalDocs == null ? 0 : this.externalDocs.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.vendorExtensions == null ? 0 : this.vendorExtensions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tag other = (Tag)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.externalDocs == null ? other.externalDocs != null : !this.externalDocs.equals(other.externalDocs)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.vendorExtensions == null ? other.vendorExtensions != null : !this.vendorExtensions.equals(other.vendorExtensions));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Map<String, Object> vendorExtensions = new LinkedHashMap<String, Object>();
        private String name;
        private String description;
        private ExternalDocs externalDocs;

        private Builder() {
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder withVendorExtensions(Map<String, Object> vendorExtensions) {
            this.vendorExtensions = vendorExtensions;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withExternalDocs(ExternalDocs externalDocs) {
            this.externalDocs = externalDocs;
            return this;
        }

        public Tag build() {
            Tag tag = new Tag();
            tag.setVendorExtensions(this.vendorExtensions);
            tag.setName(this.name);
            tag.setDescription(this.description);
            tag.setExternalDocs(this.externalDocs);
            return tag;
        }
    }
}

