/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.ss.descriptor;

import io.github.manusant.ss.descriptor.MethodDescriptor;
import java.util.Optional;

public class ParameterDescriptor {
    private String name;
    private String pattern;
    private ParameterType type;
    private String description;
    private boolean required = false;
    private String example;
    private Boolean allowEmptyValue;
    private Class object;
    private Class collectionOf;
    private String defaultValue;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public ParameterType getType() {
        return this.type;
    }

    public void setType(ParameterType type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getExample() {
        return this.example;
    }

    public void setExample(String example) {
        this.example = example;
    }

    public Boolean getAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    public void setAllowEmptyValue(Boolean allowEmptyValue) {
        this.allowEmptyValue = allowEmptyValue;
    }

    public Class getObject() {
        return this.object;
    }

    public void setObject(Class object) {
        this.object = object;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Class getCollectionOf() {
        return this.collectionOf;
    }

    public void setCollectionOf(Class collectionOf) {
        this.collectionOf = collectionOf;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(MethodDescriptor.Builder methodDescriptor) {
        return new Builder(methodDescriptor);
    }

    public static final class Builder {
        private String name;
        private String pattern;
        private ParameterType type;
        private String description;
        private boolean required = false;
        private String example;
        private Boolean allowEmptyValue;
        private Class object;
        private Class collectionOf;
        private String defaultValue;
        private MethodDescriptor.Builder methodDescriptor;

        private Builder() {
        }

        private Builder(MethodDescriptor.Builder methodDescriptor) {
            this.methodDescriptor = methodDescriptor;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withPattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public Builder withType(ParameterType type) {
            this.type = type;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withRequired(boolean required) {
            this.required = required;
            return this;
        }

        public Builder withExample(String example) {
            this.example = example;
            return this;
        }

        public Builder withAllowEmptyValue(Boolean allowEmptyValue) {
            this.allowEmptyValue = allowEmptyValue;
            return this;
        }

        public Builder withObject(Class object) {
            this.object = object;
            return this;
        }

        public Builder withCollectionOf(Class collectionOf) {
            this.collectionOf = collectionOf;
            return this;
        }

        public Builder withDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public ParameterDescriptor build() {
            ParameterDescriptor parameterDescriptor = new ParameterDescriptor();
            parameterDescriptor.setName(this.name);
            parameterDescriptor.setPattern(this.pattern);
            parameterDescriptor.setType(this.type);
            parameterDescriptor.setDescription(this.description);
            parameterDescriptor.setRequired(this.required);
            parameterDescriptor.setExample(this.example);
            parameterDescriptor.setAllowEmptyValue(this.allowEmptyValue);
            parameterDescriptor.setObject(this.object);
            parameterDescriptor.setCollectionOf(this.collectionOf);
            parameterDescriptor.setDefaultValue(this.defaultValue);
            return parameterDescriptor;
        }

        public MethodDescriptor.Builder and() {
            Optional.ofNullable(this.methodDescriptor).orElseThrow(() -> new IllegalStateException("AND operation is only available if building from a MethodDescriptor"));
            ParameterDescriptor parameter = this.build();
            this.methodDescriptor.withParam(parameter);
            return this.methodDescriptor;
        }
    }

    public static enum ParameterType {
        PATH,
        QUERY;

    }
}

