/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.ss.descriptor;

import io.github.manusant.ss.model.ExternalDocs;
import io.github.manusant.ss.model.Tag;

public class EndpointDescriptor {
    private String nameSpace;
    private String path;
    private Tag tag;
    private String description;
    private ExternalDocs externalDoc;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Tag getTag() {
        return this.tag;
    }

    public void setTag(Tag tag) {
        this.tag = tag;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ExternalDocs getExternalDoc() {
        return this.externalDoc;
    }

    public void setExternalDoc(ExternalDocs externalDoc) {
        this.externalDoc = externalDoc;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public static Builder endpointPath(String path) {
        return new Builder().withPath(path);
    }

    public static final class Builder {
        private String path;
        private String description;
        private ExternalDocs externalDoc;

        private Builder() {
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder withPath(String path) {
            this.path = path;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withExternalDoc(ExternalDocs externalDoc) {
            this.externalDoc = externalDoc;
            return this;
        }

        private String getTag() {
            return this.path.contains("/") ? this.path.substring(1) : this.path;
        }

        public EndpointDescriptor build() {
            EndpointDescriptor endpointDescriptor = new EndpointDescriptor();
            endpointDescriptor.setPath(this.path);
            endpointDescriptor.setTag(Tag.newBuilder().withName(this.getTag()).withDescription(this.description).withExternalDocs(this.externalDoc).build());
            endpointDescriptor.setDescription(this.description);
            endpointDescriptor.setExternalDoc(this.externalDoc);
            return endpointDescriptor;
        }
    }
}

