/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.ss;

import com.beerboy.spark.typify.provider.GsonProvider;
import com.beerboy.spark.typify.spec.IgnoreSpec;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import io.github.manusant.ss.ApiEndpoint;
import io.github.manusant.ss.Swagger;
import io.github.manusant.ss.SwaggerHammer;
import io.github.manusant.ss.conf.IpResolver;
import io.github.manusant.ss.conf.VersionResolver;
import io.github.manusant.ss.descriptor.EndpointDescriptor;
import io.github.manusant.ss.model.Contact;
import io.github.manusant.ss.model.ExternalDocs;
import io.github.manusant.ss.model.Info;
import io.github.manusant.ss.model.License;
import io.github.manusant.ss.model.Scheme;
import io.github.manusant.ss.rest.Endpoint;
import io.github.manusant.ss.rest.EndpointResolver;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.ExceptionHandler;
import spark.Filter;
import spark.HaltException;
import spark.Service;

public class SparkSwagger {
    private static final Logger LOGGER = LoggerFactory.getLogger(SparkSwagger.class);
    public static final String CONF_FILE_NAME = "spark-swagger.conf";
    private final String apiPath;
    private final Swagger swagger;
    private final Service spark;
    private final Config config;
    private String version;

    private SparkSwagger(Service spark, String confPath, String version) {
        this.spark = spark;
        this.version = version;
        this.swagger = new Swagger();
        this.config = ConfigFactory.parseResources((String)(confPath != null ? confPath : CONF_FILE_NAME));
        this.apiPath = this.config.getString("spark-swagger.basePath");
        this.swagger.setBasePath(this.apiPath);
        this.swagger.setExternalDocs(ExternalDocs.newBuilder().build());
        this.swagger.setHost(this.getHost());
        this.swagger.setInfo(this.getInfo());
        this.configDocRoute();
    }

    private void configDocRoute() {
        String uiFolder = SwaggerHammer.getUiFolder(this.apiPath);
        SwaggerHammer.createDir(SwaggerHammer.getSwaggerUiFolder());
        SwaggerHammer.createDir(uiFolder);
        this.spark.externalStaticFileLocation(uiFolder);
        LOGGER.debug("Spark-Swagger: UI folder deployed at {}", (Object)uiFolder);
        this.spark.options("/*", (request, response) -> {
            String accessControlRequestMethod;
            String accessControlRequestHeaders = request.headers("Access-Control-Request-Headers");
            if (accessControlRequestHeaders != null) {
                response.header("Access-Control-Allow-Headers", accessControlRequestHeaders);
            }
            if ((accessControlRequestMethod = request.headers("Access-Control-Request-Method")) != null) {
                response.header("Access-Control-Allow-Methods", accessControlRequestMethod);
            }
            return "OK";
        });
        this.spark.before((request, response) -> response.header("Access-Control-Allow-Origin", "*"));
        LOGGER.debug("Spark-Swagger: CORS enabled and allow Origin *");
    }

    public String getApiPath() {
        return this.apiPath;
    }

    public String getVersion() {
        return this.version;
    }

    public Service getSpark() {
        return this.spark;
    }

    public static SparkSwagger of(Service spark) {
        return new SparkSwagger(spark, null, null);
    }

    public static SparkSwagger of(Service spark, String confPath) {
        return new SparkSwagger(spark, confPath, null);
    }

    public SparkSwagger version(String version) {
        this.version = version;
        return this;
    }

    public SparkSwagger ignores(Supplier<IgnoreSpec> confSupplier) {
        this.swagger.ignores(confSupplier.get());
        GsonProvider.create((IgnoreSpec)confSupplier.get());
        return this;
    }

    public void generateDoc() throws IOException {
        new SwaggerHammer().prepareUi(this.config, this.swagger);
    }

    public ApiEndpoint endpoint(EndpointDescriptor.Builder descriptorBuilder, Filter filter) {
        Optional.ofNullable(this.apiPath).orElseThrow(() -> new IllegalStateException("API Path must be specified in order to build REST endpoint"));
        EndpointDescriptor descriptor = descriptorBuilder.build();
        this.spark.before(this.apiPath + descriptor.getPath() + "/*", filter);
        ApiEndpoint apiEndpoint = new ApiEndpoint(this, descriptor);
        this.swagger.addApiEndpoint(apiEndpoint);
        return apiEndpoint;
    }

    public SparkSwagger endpoint(EndpointDescriptor.Builder descriptorBuilder, Filter filter, Consumer<ApiEndpoint> endpointDef) {
        Optional.ofNullable(this.apiPath).orElseThrow(() -> new IllegalStateException("API Path must be specified in order to build REST endpoint"));
        EndpointDescriptor descriptor = descriptorBuilder.build();
        this.spark.before(this.apiPath + descriptor.getPath() + "/*", filter);
        ApiEndpoint apiEndpoint = new ApiEndpoint(this, descriptor);
        endpointDef.accept(apiEndpoint);
        this.swagger.addApiEndpoint(apiEndpoint);
        return this;
    }

    public SparkSwagger endpoint(Endpoint endpoint) {
        Optional.ofNullable(endpoint).orElseThrow(() -> new IllegalStateException("API Endpoint cannot be null"));
        endpoint.bind(this);
        return this;
    }

    public SparkSwagger endpoints(EndpointResolver resolver) {
        Optional.ofNullable(resolver).orElseThrow(() -> new IllegalStateException("API Endpoint Resolver cannot be null"));
        resolver.endpoints().forEach(this::endpoint);
        return this;
    }

    public SparkSwagger before(Filter filter) {
        this.spark.before(this.apiPath + "/*", filter);
        return this;
    }

    public SparkSwagger after(Filter filter) {
        this.spark.after(this.apiPath + "/*", filter);
        return this;
    }

    public synchronized SparkSwagger exception(Class<? extends Exception> exceptionClass, ExceptionHandler handler) {
        this.spark.exception(exceptionClass, handler);
        return this;
    }

    public HaltException halt() {
        return this.spark.halt();
    }

    public HaltException halt(int status) {
        return this.spark.halt(status);
    }

    public HaltException halt(String body) {
        return this.spark.halt(body);
    }

    public HaltException halt(int status, String body) {
        return this.spark.halt(status, body);
    }

    private String getHost() {
        String host = this.config.getString("spark-swagger.host");
        if (host == null || host.contains("localhost") && host.split(":").length != 2) {
            throw new IllegalArgumentException("Host is required. If host name is 'localhost' you also need to specify port");
        }
        if (host.contains("localhost")) {
            String[] hostParts = host.split(":");
            host = IpResolver.resolvePublicIp() + ":" + hostParts[1];
        }
        LOGGER.debug("Spark-Swagger: Host resolved to {}", (Object)host);
        return host;
    }

    private Info getInfo() {
        Config licenseConfig;
        Config externalDocConf;
        Config projectConfig;
        Config infoConfig = Optional.ofNullable(this.config.getConfig("spark-swagger.info")).orElseThrow(() -> new IllegalArgumentException("'spark-swagger.info' configuration is required"));
        if (this.version == null && (projectConfig = this.config.getConfig("spark-swagger.info.project")) != null) {
            this.version = VersionResolver.resolveVersion(projectConfig.getString("groupId"), projectConfig.getString("artifactId"));
        }
        if ((externalDocConf = this.config.getConfig("spark-swagger.info.externalDoc")) != null) {
            ExternalDocs doc = ExternalDocs.newBuilder().withDescription(externalDocConf.getString("description")).withUrl(externalDocConf.getString("url")).build();
            this.swagger.setExternalDocs(doc);
        }
        Info info = new Info();
        info.description(infoConfig.getString("description"));
        info.version(this.version);
        info.title(infoConfig.getString("title"));
        info.termsOfService(infoConfig.getString("termsOfService"));
        List schemeStrings = Optional.ofNullable(infoConfig.getStringList("schemes")).orElseThrow(() -> new IllegalArgumentException("'spark-swagger.info.schemes' configuration is required"));
        List<Scheme> schemes = schemeStrings.stream().filter(s -> Scheme.forValue(s) != null).map(Scheme::forValue).collect(Collectors.toList());
        if (schemes.isEmpty()) {
            throw new IllegalArgumentException("At least one Scheme mus be specified. Use 'spark-swagger.info.schemes' property. spark-swagger.info.schemes =[\"HTTP\"]");
        }
        this.swagger.schemes(schemes);
        Config contactConfig = this.config.getConfig("spark-swagger.info.contact");
        if (contactConfig != null) {
            Contact contact = new Contact();
            contact.name(contactConfig.getString("name"));
            contact.email(contactConfig.getString("email"));
            contact.url(contactConfig.getString("url"));
            info.setContact(contact);
        }
        if ((licenseConfig = this.config.getConfig("spark-swagger.info.license")) != null) {
            License license = new License();
            license.name(licenseConfig.getString("name"));
            license.url(licenseConfig.getString("url"));
            info.setLicense(license);
        }
        return info;
    }
}

