/*
 * Decompiled with CFR 0.152.
 */
package com.beerboy.ss.model;

import com.beerboy.ss.model.AbstractModel;
import com.beerboy.ss.model.Xml;
import com.beerboy.ss.model.properties.Property;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@XmlType(propOrder={"type", "required", "discriminator", "properties"})
@JsonPropertyOrder(value={"type", "required", "discriminator", "properties"})
public class ModelImpl
extends AbstractModel {
    public static final String OBJECT = "object";
    private String type;
    private String format;
    private String name;
    private List<String> required;
    private Map<String, Property> properties;
    private Boolean allowEmptyValue;
    private Boolean uniqueItems;
    private boolean isSimple = false;
    private String description;
    private Object example;
    private Property additionalProperties;
    private String discriminator;
    @JsonProperty(value="default")
    private String defaultValue;
    private List<String> _enum;
    private BigDecimal minimum;
    private BigDecimal maximum;

    public ModelImpl _enum(List<String> value) {
        this._enum = value;
        return this;
    }

    public ModelImpl _enum(String value) {
        if (this._enum == null) {
            this._enum = new ArrayList<String>();
        }
        this._enum.add(value);
        return this;
    }

    public List<String> getEnum() {
        return this._enum;
    }

    public void setEnum(List<String> _enum) {
        this._enum = _enum;
    }

    public ModelImpl discriminator(String discriminator) {
        this.setDiscriminator(discriminator);
        return this;
    }

    public ModelImpl type(String type) {
        this.setType(type);
        return this;
    }

    public ModelImpl format(String format) {
        this.setFormat(format);
        return this;
    }

    public ModelImpl name(String name) {
        this.setName(name);
        return this;
    }

    public ModelImpl uniqueItems(Boolean uniqueItems) {
        this.setUniqueItems(uniqueItems);
        return this;
    }

    public ModelImpl allowEmptyValue(Boolean allowEmptyValue) {
        this.setAllowEmptyValue(allowEmptyValue);
        return this;
    }

    public ModelImpl description(String description) {
        this.setDescription(description);
        return this;
    }

    public ModelImpl property(String key, Property property) {
        this.addProperty(key, property);
        return this;
    }

    public ModelImpl example(Object example) {
        this.setExample(example);
        return this;
    }

    public ModelImpl additionalProperties(Property additionalProperties) {
        this.setAdditionalProperties(additionalProperties);
        return this;
    }

    public ModelImpl required(String name) {
        this.addRequired(name);
        return this;
    }

    public ModelImpl xml(Xml xml) {
        this.setXml(xml);
        return this;
    }

    public ModelImpl minimum(BigDecimal minimum) {
        this.minimum = minimum;
        return this;
    }

    public ModelImpl maximum(BigDecimal maximum) {
        this.maximum = maximum;
        return this;
    }

    public String getDiscriminator() {
        return this.discriminator;
    }

    public void setDiscriminator(String discriminator) {
        this.discriminator = discriminator;
    }

    @JsonIgnore
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonIgnore
    public boolean isSimple() {
        return this.isSimple;
    }

    public void setSimple(boolean isSimple) {
        this.isSimple = isSimple;
    }

    public Property getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Property additionalProperties) {
        this.type(OBJECT);
        this.additionalProperties = additionalProperties;
    }

    public Boolean getAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    public void setAllowEmptyValue(Boolean allowEmptyValue) {
        if (allowEmptyValue != null) {
            this.allowEmptyValue = allowEmptyValue;
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void addRequired(String name) {
        if (this.required == null) {
            this.required = new ArrayList<String>();
        }
        this.required.add(name);
        Property p = this.properties.get(name);
        if (p != null) {
            p.setRequired(true);
        }
    }

    public List<String> getRequired() {
        ArrayList<String> output = new ArrayList<String>();
        if (this.properties != null) {
            for (String key : this.properties.keySet()) {
                Property prop = this.properties.get(key);
                if (prop == null || !prop.getRequired()) continue;
                output.add(key);
            }
        }
        Collections.sort(output);
        if (output.size() > 0) {
            return output;
        }
        return null;
    }

    public void setRequired(List<String> required) {
        this.required = required;
        if (required != null && this.properties != null) {
            for (String s : required) {
                Property p = this.properties.get(s);
                if (p == null) continue;
                p.setRequired(true);
            }
        }
    }

    public void addProperty(String key, Property property) {
        if (property == null) {
            return;
        }
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Property>();
        }
        if (this.required != null) {
            for (String ek : this.required) {
                if (!key.equals(ek)) continue;
                property.setRequired(true);
            }
        }
        this.properties.put(key, property);
    }

    @Override
    public Map<String, Property> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Map<String, Property> properties) {
        if (properties != null) {
            for (String key : properties.keySet()) {
                this.addProperty(key, properties.get(key));
            }
        }
    }

    @Override
    public Object getExample() {
        if (this.example == null) {
            // empty if block
        }
        return this.example;
    }

    @Override
    public void setExample(Object example) {
        this.example = example;
    }

    public Object getDefaultValue() {
        if (this.defaultValue == null) {
            return null;
        }
        try {
            if ("integer".equals(this.type)) {
                return new Integer(this.defaultValue);
            }
            if ("number".equals(this.type)) {
                return new BigDecimal(this.defaultValue);
            }
        }
        catch (Exception e) {
            return null;
        }
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public BigDecimal getMinimum() {
        return this.minimum;
    }

    public void setMinimum(BigDecimal minimum) {
        this.minimum = minimum;
    }

    public BigDecimal getMaximum() {
        return this.maximum;
    }

    public void setMaximum(BigDecimal maximum) {
        this.maximum = maximum;
    }

    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModelImpl)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModelImpl model = (ModelImpl)o;
        if (this.isSimple != model.isSimple) {
            return false;
        }
        if (this.type != null ? !this.type.equals(model.type) : model.type != null) {
            return false;
        }
        if (this.format != null ? !this.format.equals(model.format) : model.format != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(model.name) : model.name != null) {
            return false;
        }
        if (this.required != null ? !this.required.equals(model.required) : model.required != null) {
            return false;
        }
        if (this.properties != null ? !this.properties.equals(model.properties) : model.properties != null) {
            return false;
        }
        if (this.allowEmptyValue != null ? !this.allowEmptyValue.equals(model.allowEmptyValue) : model.allowEmptyValue != null) {
            return false;
        }
        if (this.uniqueItems != null ? !this.uniqueItems.equals(model.uniqueItems) : model.uniqueItems != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(model.description) : model.description != null) {
            return false;
        }
        if (this.example != null ? !this.example.equals(model.example) : model.example != null) {
            return false;
        }
        if (this.additionalProperties != null ? !this.additionalProperties.equals(model.additionalProperties) : model.additionalProperties != null) {
            return false;
        }
        if (this.discriminator != null ? !this.discriminator.equals(model.discriminator) : model.discriminator != null) {
            return false;
        }
        if (this.defaultValue != null ? !this.defaultValue.equals(model.defaultValue) : model.defaultValue != null) {
            return false;
        }
        if (this._enum != null ? !this._enum.equals(model._enum) : model._enum != null) {
            return false;
        }
        if (this.minimum != null ? !this.minimum.equals(model.minimum) : model.minimum != null) {
            return false;
        }
        return this.maximum != null ? this.maximum.equals(model.maximum) : model.maximum == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.required != null ? this.required.hashCode() : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        result = 31 * result + (this.allowEmptyValue != null ? this.allowEmptyValue.hashCode() : 0);
        result = 31 * result + (this.uniqueItems != null ? this.uniqueItems.hashCode() : 0);
        result = 31 * result + (this.isSimple ? 1 : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.example != null ? this.example.hashCode() : 0);
        result = 31 * result + (this.additionalProperties != null ? this.additionalProperties.hashCode() : 0);
        result = 31 * result + (this.discriminator != null ? this.discriminator.hashCode() : 0);
        result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
        result = 31 * result + (this._enum != null ? this._enum.hashCode() : 0);
        result = 31 * result + (this.minimum != null ? this.minimum.hashCode() : 0);
        result = 31 * result + (this.maximum != null ? this.maximum.hashCode() : 0);
        return result;
    }

    public void setUniqueItems(Boolean uniqueItems) {
        this.uniqueItems = uniqueItems;
    }

    @Override
    public Object clone() {
        ModelImpl cloned = new ModelImpl();
        super.cloneTo(cloned);
        cloned.type = this.type;
        cloned.name = this.name;
        cloned.required = this.required;
        if (this.properties != null) {
            cloned.properties = new LinkedHashMap<String, Property>(this.properties);
        }
        cloned.isSimple = this.isSimple;
        cloned.description = this.description;
        cloned.example = this.example;
        cloned.additionalProperties = this.additionalProperties;
        cloned.discriminator = this.discriminator;
        cloned.defaultValue = this.defaultValue;
        cloned.minimum = this.minimum;
        cloned.maximum = this.maximum;
        return cloned;
    }
}

