/*
 * Decompiled with CFR 0.152.
 */
package com.beerboy.ss.factory;

import com.beerboy.ss.descriptor.ParameterDescriptor;
import com.beerboy.ss.model.parameters.AbstractSerializableParameter;
import com.beerboy.ss.model.parameters.Parameter;
import com.beerboy.ss.model.parameters.PathParameter;
import com.beerboy.ss.model.parameters.QueryParameter;
import com.beerboy.ss.model.properties.ArrayProperty;
import com.beerboy.ss.model.properties.BooleanProperty;
import com.beerboy.ss.model.properties.ByteArrayProperty;
import com.beerboy.ss.model.properties.DecimalProperty;
import com.beerboy.ss.model.properties.DoubleProperty;
import com.beerboy.ss.model.properties.FloatProperty;
import com.beerboy.ss.model.properties.IntegerProperty;
import com.beerboy.ss.model.properties.LongProperty;
import com.beerboy.ss.model.properties.Property;
import com.beerboy.ss.model.properties.StringProperty;
import com.beerboy.ss.model.properties.UUIDProperty;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import spark.utils.SparkUtils;

public class ParamsFactory {
    public static List<Parameter> create(String pathUri, List<ParameterDescriptor> parameterDescriptors) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        List<Parameter> pathParams = ParamsFactory.createPathParams(pathUri, parameterDescriptors);
        parameters.addAll(pathParams);
        List<Parameter> queryParams = ParamsFactory.createQueryParams(parameterDescriptors);
        parameters.addAll(queryParams);
        return parameters;
    }

    private static List<Parameter> createPathParams(String pathUri, List<ParameterDescriptor> parameterDescriptors) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (String uriPart : SparkUtils.convertRouteToList((String)pathUri)) {
            if (!SparkUtils.isParam((String)uriPart)) continue;
            try {
                Optional foundParam;
                String param = URLDecoder.decode(uriPart, "UTF-8");
                String decodedParam = param.contains(":") ? param.substring(param.indexOf(":") + 1) : param;
                Optional<Object> optional = foundParam = parameterDescriptors != null ? parameterDescriptors.stream().filter(parameterDescriptor -> parameterDescriptor.getName().equals(decodedParam)).findFirst() : Optional.empty();
                if (foundParam.isPresent()) {
                    ParameterDescriptor parameterDescriptor2 = (ParameterDescriptor)foundParam.get();
                    if (parameterDescriptor2.getType() != ParameterDescriptor.ParameterType.PATH) continue;
                    parameters.add(ParamsFactory.toPath(parameterDescriptor2));
                    continue;
                }
                parameters.add(ParamsFactory.toGeneric(decodedParam));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return parameters;
    }

    private static List<Parameter> createQueryParams(List<ParameterDescriptor> parameterDescriptors) {
        return ParamsFactory.filter(parameterDescriptors, ParameterDescriptor.ParameterType.QUERY).stream().map(ParamsFactory::toQuey).collect(Collectors.toList());
    }

    public static String formatPath(String pathUri) {
        StringBuilder formatted = new StringBuilder();
        List uriParts = SparkUtils.convertRouteToList((String)pathUri);
        for (String uriPart : uriParts) {
            try {
                formatted.append("/");
                if (SparkUtils.isParam((String)uriPart)) {
                    String param = URLDecoder.decode(uriPart, "UTF-8");
                    String decodedParam = param.contains(":") ? param.substring(param.indexOf(":") + 1) : param;
                    formatted.append("{").append(decodedParam).append("}");
                    continue;
                }
                formatted.append(uriPart);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        String path = formatted.toString();
        return path.isEmpty() ? "/" : path;
    }

    private static PathParameter toGeneric(String param) {
        PathParameter parameter = new PathParameter();
        parameter.setName(param);
        parameter.setRequired(true);
        parameter.setProperty(ParamsFactory.createProperty(String.class));
        return parameter;
    }

    private static PathParameter toPath(ParameterDescriptor parameterDescriptor) {
        PathParameter parameter = new PathParameter();
        ParamsFactory.bindAttributes(parameterDescriptor, parameter);
        parameter.setRequired(true);
        return parameter;
    }

    private static QueryParameter toQuey(ParameterDescriptor parameterDescriptor) {
        QueryParameter parameter = new QueryParameter();
        ParamsFactory.bindAttributes(parameterDescriptor, parameter);
        return parameter;
    }

    private static void bindAttributes(ParameterDescriptor parameterDescriptor, AbstractSerializableParameter parameter) {
        parameter.setName(parameterDescriptor.getName());
        parameter.setDescription(parameterDescriptor.getDescription());
        parameter.setPattern(parameterDescriptor.getPattern());
        parameter.setExample(parameterDescriptor.getExample());
        parameter.setAllowEmptyValue(parameterDescriptor.getAllowEmptyValue());
        parameter.setDefaultValue(parameterDescriptor.getDefaultValue());
        if (parameterDescriptor.getObject() != null) {
            parameter.setProperty(ParamsFactory.createProperty(parameterDescriptor.getObject()));
        } else if (parameterDescriptor.getCollectionOf() != null) {
            Property itemProperty = ParamsFactory.createProperty(parameterDescriptor.getCollectionOf());
            ArrayProperty collectionProperty = new ArrayProperty();
            collectionProperty.setItems(itemProperty);
            parameter.setProperty(collectionProperty);
        } else {
            parameter.setProperty(ParamsFactory.createProperty(String.class));
        }
    }

    private static Property createProperty(Class type) {
        if (type.isEnum()) {
            StringProperty property = new StringProperty();
            property._enum(Stream.of(type.getEnumConstants()).map(o -> ((Enum)o).name()).collect(Collectors.toList()));
            return property;
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            return new BooleanProperty();
        }
        if (type == byte[].class) {
            return new ByteArrayProperty();
        }
        if (type.equals(Number.class)) {
            return new DecimalProperty();
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return new DoubleProperty();
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return new FloatProperty();
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return new IntegerProperty();
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return new LongProperty();
        }
        if (type.equals(String.class)) {
            return new StringProperty();
        }
        if (type.equals(UUID.class)) {
            return new UUIDProperty();
        }
        throw new UnsupportedOperationException("Only 'String' or 'primitive' types can be used as parameters");
    }

    private static List<ParameterDescriptor> filter(List<ParameterDescriptor> params, ParameterDescriptor.ParameterType type) {
        return params.stream().filter(parameterDescriptor -> parameterDescriptor.getType() == type).collect(Collectors.toList());
    }
}

