/*
 * Decompiled with CFR 0.152.
 */
package com.beerboy.ss;

import com.beerboy.ss.Swagger;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwaggerParser.class);

    public static void parseYaml(Swagger swagger, String filePath) throws IOException {
        LOGGER.debug("Spark-Swagger: Start parsing Swagger definitions");
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        swagger.parse();
        mapper.writeValue(new File(filePath), (Object)swagger);
        LOGGER.debug("Spark-Swagger: Swagger definitions saved as " + filePath + " [YAML]");
    }

    public static void parseJson(Swagger swagger, String filePath) throws IOException {
        LOGGER.debug("Spark-Swagger: Start parsing Swagger definitions");
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        swagger.parse();
        mapper.writeValue(new File(filePath), (Object)swagger);
        LOGGER.debug("Spark-Swagger: Swagger definitions saved as " + filePath + " [JSON]");
    }

    public static void parseJs(Swagger swagger, String filePath) throws IOException {
        LOGGER.debug("Spark-Swagger: Start parsing Swagger definitions");
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        swagger.parse();
        String js = mapper.writeValueAsString((Object)swagger);
        js = "window.swaggerSpec=" + js;
        File uiFolder = new File(filePath);
        uiFolder.delete();
        try (PrintWriter out = new PrintWriter(filePath);){
            out.println(js);
        }
        LOGGER.debug("Spark-Swagger: Swagger definitions saved as " + filePath + " [JS]");
    }
}

