/*
 * Decompiled with CFR 0.152.
 */
package com.coriant.sdn.ss.factory;

import com.coriant.sdn.ss.model.Model;
import com.coriant.sdn.ss.model.ModelImpl;
import com.coriant.sdn.ss.model.properties.ArrayProperty;
import com.coriant.sdn.ss.model.properties.BooleanProperty;
import com.coriant.sdn.ss.model.properties.ByteArrayProperty;
import com.coriant.sdn.ss.model.properties.DateProperty;
import com.coriant.sdn.ss.model.properties.DecimalProperty;
import com.coriant.sdn.ss.model.properties.DoubleProperty;
import com.coriant.sdn.ss.model.properties.FileProperty;
import com.coriant.sdn.ss.model.properties.FloatProperty;
import com.coriant.sdn.ss.model.properties.IntegerProperty;
import com.coriant.sdn.ss.model.properties.LongProperty;
import com.coriant.sdn.ss.model.properties.Property;
import com.coriant.sdn.ss.model.properties.RefProperty;
import com.coriant.sdn.ss.model.properties.StringProperty;
import com.coriant.sdn.ss.model.properties.UUIDProperty;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.sql.Date;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefinitionsFactory {
    public static Map<String, Model> create(Class type) {
        HashMap<String, Model> definitions = new HashMap<String, Model>();
        if (DefinitionsFactory.isObject(type)) {
            ModelImpl model = new ModelImpl();
            model.setType("object");
            definitions.put(type.getSimpleName(), model);
            Map<String, Model> refDefinitions = DefinitionsFactory.parseProperties(model, type.getDeclaredFields());
            definitions.putAll(refDefinitions);
        }
        return definitions;
    }

    private static Map<String, Model> parseProperties(ModelImpl model, Field[] fields) {
        HashMap<String, Model> refDefinitions = new HashMap<String, Model>();
        for (Field field : fields) {
            Class<?> childType;
            if (!DefinitionsFactory.isViable(field)) continue;
            Property property = DefinitionsFactory.createProperty(field, field.getType());
            model.addProperty(field.getName(), property);
            if (DefinitionsFactory.isRef(field.getType())) {
                Map<String, Model> definitions = DefinitionsFactory.create(field.getType());
                refDefinitions.putAll(definitions);
                continue;
            }
            if (!field.getType().isArray() && !Collection.class.isAssignableFrom(field.getType()) || !DefinitionsFactory.isRef(childType = DefinitionsFactory.getCollectionType(field))) continue;
            Map<String, Model> definitions = DefinitionsFactory.create(childType);
            refDefinitions.putAll(definitions);
        }
        return refDefinitions;
    }

    private static boolean isViable(Field field) {
        return !Modifier.isStatic(field.getModifiers());
    }

    public static Property createProperty(Field field, Class<?> fieldClass) {
        if (fieldClass.isEnum()) {
            StringProperty property = new StringProperty();
            property._enum(Stream.of(fieldClass.getEnumConstants()).map(o -> ((Enum)o).name()).collect(Collectors.toList()));
            return property;
        }
        if (fieldClass.equals(Boolean.TYPE) || fieldClass.equals(Boolean.class)) {
            return new BooleanProperty();
        }
        if (fieldClass == byte[].class) {
            return new ByteArrayProperty();
        }
        if (fieldClass.equals(java.util.Date.class) || fieldClass.equals(Date.class)) {
            return new DateProperty();
        }
        if (fieldClass.equals(Number.class)) {
            return new DecimalProperty();
        }
        if (fieldClass.equals(Double.class) || fieldClass.equals(Double.TYPE)) {
            return new DoubleProperty();
        }
        if (fieldClass.equals(Float.class) || fieldClass.equals(Float.TYPE)) {
            return new FloatProperty();
        }
        if (fieldClass.equals(Integer.class) || fieldClass.equals(Integer.TYPE)) {
            return new IntegerProperty();
        }
        if (fieldClass.equals(Long.class) || fieldClass.equals(Long.TYPE)) {
            return new LongProperty();
        }
        if (fieldClass.equals(String.class)) {
            return new StringProperty();
        }
        if (fieldClass.equals(UUID.class)) {
            return new UUIDProperty();
        }
        if (fieldClass.isArray() || Collection.class.isAssignableFrom(fieldClass)) {
            ArrayProperty property = new ArrayProperty();
            property.setItems(DefinitionsFactory.getCollectionProperty(field));
            return property;
        }
        if (File.class.isAssignableFrom(fieldClass)) {
            return new FileProperty();
        }
        RefProperty property = new RefProperty();
        property.set$ref("#/definitions/" + fieldClass.getSimpleName());
        return property;
    }

    private static boolean isRef(Class<?> fieldClass) {
        return !fieldClass.isEnum() && !fieldClass.equals(Boolean.TYPE) && !fieldClass.equals(Boolean.class) && fieldClass != byte[].class && !fieldClass.equals(java.util.Date.class) && !fieldClass.equals(Date.class) && !fieldClass.equals(Number.class) && !fieldClass.equals(Double.class) && !fieldClass.equals(Double.TYPE) && !fieldClass.equals(Float.class) && !fieldClass.equals(Float.TYPE) && !fieldClass.equals(Integer.class) && !fieldClass.equals(Integer.TYPE) && !fieldClass.equals(Long.class) && !fieldClass.equals(Long.TYPE) && !fieldClass.equals(String.class) && !fieldClass.equals(UUID.class) && !fieldClass.isArray() && !Collection.class.isAssignableFrom(fieldClass) && !File.class.isAssignableFrom(fieldClass) && !fieldClass.getCanonicalName().contains("java");
    }

    private static boolean isObject(Class<?> fieldClass) {
        return !fieldClass.isEnum() && !fieldClass.equals(Boolean.TYPE) && !fieldClass.equals(Boolean.class) && fieldClass != byte[].class && !fieldClass.equals(Number.class) && !fieldClass.equals(Double.class) && !fieldClass.equals(Double.TYPE) && !fieldClass.equals(Float.class) && !fieldClass.equals(Float.TYPE) && !fieldClass.equals(Integer.class) && !fieldClass.equals(Integer.TYPE) && !fieldClass.equals(Long.class) && !fieldClass.equals(Long.TYPE) && !fieldClass.equals(String.class);
    }

    private static Property getCollectionProperty(Field collectionField) {
        Class<?> childType = DefinitionsFactory.getCollectionType(collectionField);
        return DefinitionsFactory.createProperty(collectionField, childType);
    }

    private static Class<?> getCollectionType(Field collectionField) {
        ParameterizedType parameterizedType = (ParameterizedType)collectionField.getGenericType();
        return (Class)parameterizedType.getActualTypeArguments()[0];
    }
}

