/*
 * Decompiled with CFR 0.152.
 */
package com.coriant.sdn.ss.descriptor;

import com.coriant.sdn.ss.descriptor.ParameterDescriptor;
import com.coriant.sdn.ss.model.ExternalDocs;
import com.coriant.sdn.ss.model.HttpMethod;
import com.coriant.sdn.ss.model.Response;
import com.coriant.sdn.ss.rest.RestResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MethodDescriptor {
    private HttpMethod method;
    private String path;
    private String description;
    private Class requestType;
    private boolean requestAsCollection;
    private Class responseType;
    private boolean responseAsCollection;
    private String operationId;
    private List<String> consumes;
    private List<String> produces;
    private List<ParameterDescriptor> parameters = new ArrayList<ParameterDescriptor>();
    private Map<String, Response> responses;
    private ExternalDocs externalDocs;
    private Boolean deprecated;

    public HttpMethod getMethod() {
        return this.method;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Class getRequestType() {
        return this.requestType;
    }

    public void setRequestType(Class requestType) {
        this.requestType = requestType;
    }

    public boolean isRequestAsCollection() {
        return this.requestAsCollection;
    }

    public void setRequestAsCollection(boolean requestAsCollection) {
        this.requestAsCollection = requestAsCollection;
    }

    public Class getResponseType() {
        return this.responseType;
    }

    public void setResponseType(Class responseType) {
        this.responseType = responseType;
    }

    public boolean isResponseAsCollection() {
        return this.responseAsCollection;
    }

    public void setResponseAsCollection(boolean responseAsCollection) {
        this.responseAsCollection = responseAsCollection;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public List<ParameterDescriptor> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<ParameterDescriptor> parameters) {
        this.parameters = parameters;
    }

    public Map<String, Response> getResponses() {
        return this.responses;
    }

    public void setResponses(Map<String, Response> responses) {
        this.responses = responses;
    }

    public ExternalDocs getExternalDocs() {
        return this.externalDocs;
    }

    public void setExternalDocs(ExternalDocs externalDocs) {
        this.externalDocs = externalDocs;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    public static Builder path(String path) {
        return new Builder().withPath(path);
    }

    public static final class Builder {
        private HttpMethod method;
        private String path;
        private String description;
        private Class requestType;
        private boolean requestAsCollection;
        private Class responseType;
        private boolean responseAsCollection;
        private String operationId;
        private List<String> consumes;
        private List<String> produces;
        private List<ParameterDescriptor> parameters = new ArrayList<ParameterDescriptor>();
        private Map<String, Response> responses;
        private ExternalDocs externalDocs;
        private Boolean deprecated;

        private Builder() {
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder withMethod(HttpMethod method) {
            this.method = method;
            return this;
        }

        public Builder withPath(String path) {
            this.path = path;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withRequestType(Class requestType) {
            this.requestType = requestType;
            return this;
        }

        public Builder withRequestAsCollection(Class itemType) {
            this.requestAsCollection = true;
            this.requestType = itemType;
            return this;
        }

        public Builder withResponseType(Class responseType) {
            this.responseType = responseType;
            return this;
        }

        public Builder withGenericResponse() {
            this.responseType = RestResponse.class;
            return this;
        }

        public Builder withResponseAsCollection(Class itemType) {
            this.responseAsCollection = true;
            this.responseType = itemType;
            return this;
        }

        public Builder withOperationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public Builder withConsumes(List<String> consumes) {
            this.consumes = consumes;
            return this;
        }

        public Builder withProduces(List<String> produces) {
            this.produces = produces;
            return this;
        }

        public Builder withParams(List<ParameterDescriptor> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder withParam(ParameterDescriptor parameter) {
            this.parameters.add(parameter);
            return this;
        }

        public ParameterDescriptor.Builder withPathParam() {
            return ParameterDescriptor.newBuilder(this).withType(ParameterDescriptor.ParameterType.PATH);
        }

        public Builder withPathParam(ParameterDescriptor param) {
            param.setType(ParameterDescriptor.ParameterType.PATH);
            this.parameters.add(param);
            return this;
        }

        public ParameterDescriptor.Builder withQueryParam() {
            return ParameterDescriptor.newBuilder(this).withType(ParameterDescriptor.ParameterType.QUERY);
        }

        public Builder withQueryParam(ParameterDescriptor param) {
            param.setType(ParameterDescriptor.ParameterType.QUERY);
            this.parameters.add(param);
            return this;
        }

        public Builder withResponses(Map<String, Response> responses) {
            this.responses = responses;
            return this;
        }

        public Builder withExternalDocs(ExternalDocs externalDocs) {
            this.externalDocs = externalDocs;
            return this;
        }

        public Builder withDeprecated(Boolean deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public MethodDescriptor build() {
            MethodDescriptor methodDescriptor = new MethodDescriptor();
            methodDescriptor.setMethod(this.method);
            methodDescriptor.setPath(this.path);
            methodDescriptor.setDescription(this.description);
            methodDescriptor.setRequestType(this.requestType);
            methodDescriptor.setRequestAsCollection(this.requestAsCollection);
            methodDescriptor.setResponseType(this.responseType);
            methodDescriptor.setResponseAsCollection(this.responseAsCollection);
            methodDescriptor.setOperationId(this.operationId);
            methodDescriptor.setConsumes(this.consumes);
            methodDescriptor.setProduces(this.produces);
            methodDescriptor.setParameters(this.parameters);
            methodDescriptor.setResponses(this.responses);
            methodDescriptor.setExternalDocs(this.externalDocs);
            methodDescriptor.setDeprecated(this.deprecated);
            return methodDescriptor;
        }
    }
}

