/*
 * Decompiled with CFR 0.152.
 */
package com.coriant.sdn.ss;

import com.coriant.sdn.ss.SparkSwagger;
import com.coriant.sdn.ss.Swagger;
import com.coriant.sdn.ss.SwaggerParser;
import com.coriant.sdn.ss.conf.Theme;
import com.coriant.sdn.ss.ui.UiTemplates;
import com.typesafe.config.Config;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerHammer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwaggerHammer.class);

    public void prepareUi(Config config, Swagger swagger) throws IOException {
        LOGGER.debug("Spark-Swagger: Start compiling Swagger UI");
        this.extractUi();
        String newIndex = this.decorateIndex(config);
        this.saveFile("index.html", newIndex);
        SwaggerParser.parseJs(swagger, SwaggerHammer.getUiFolder() + "swagger-spec.js");
        SwaggerParser.parseYaml(swagger, SwaggerHammer.getUiFolder() + "doc.yaml");
        SwaggerParser.parseJson(swagger, SwaggerHammer.getUiFolder() + "doc.json");
        this.applyTheme(config);
    }

    private void extractUi() throws IOException {
        this.createDir(SwaggerHammer.getUiFolder());
        this.extractUiFolder();
        this.extractTemplatesFolder();
        LOGGER.debug("Spark-Swagger: UI resources and templates successfully extracted");
    }

    private void extractUiFolder() throws IOException {
        String dir = "ui";
        List uiFiles = this.listFiles(dir).stream().map(filePath -> filePath.substring(filePath.indexOf(dir) + dir.length() + 1).trim()).filter(fileName -> !fileName.contains("/") && !fileName.isEmpty()).collect(Collectors.toList());
        for (String uiFileName : uiFiles) {
            InputStream uiFile = SparkSwagger.class.getClassLoader().getResourceAsStream(dir + "/" + uiFileName);
            File file = new File(SwaggerHammer.getUiFolder() + uiFileName);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            Files.copy(uiFile, file.getAbsoluteFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private void extractTemplatesFolder() throws IOException {
        File templatesFolder = new File(SwaggerHammer.getUiFolder() + "templates/");
        if (!templatesFolder.exists()) {
            templatesFolder.mkdir();
        }
        String dir = "ui/templates";
        List templateFiles = this.listFiles(dir).stream().map(filePath -> filePath.substring(filePath.indexOf(dir) + dir.length() + 1).trim()).filter(fileName -> !fileName.contains("/") && !fileName.isEmpty()).collect(Collectors.toList());
        for (String templateFileName : templateFiles) {
            InputStream templateFile = SparkSwagger.class.getClassLoader().getResourceAsStream(dir + "/" + templateFileName);
            File file = new File(SwaggerHammer.getUiFolder() + "templates/" + templateFileName);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            Files.copy(templateFile, file.getAbsoluteFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private List<String> listFiles(String prefix) throws IOException {
        ArrayList<String> uiFiles = new ArrayList<String>();
        CodeSource src = SparkSwagger.class.getProtectionDomain().getCodeSource();
        if (src != null) {
            ZipEntry e;
            URL jar = src.getLocation();
            ZipInputStream zip = new ZipInputStream(jar.openStream());
            while ((e = zip.getNextEntry()) != null) {
                String name = e.getName();
                if (!name.startsWith(prefix)) continue;
                uiFiles.add(name);
            }
        }
        return uiFiles;
    }

    private void applyTheme(Config config) throws IOException {
        LOGGER.debug("Spark-Swagger: Start applying configured CSS Theme");
        String themeName = config.getString("spark-swagger.theme");
        Theme theme = Theme.fromValue(themeName);
        String themeCss = this.readFile("templates/" + theme.getValue() + ".css", StandardCharsets.UTF_8);
        this.saveFile("swagger-ui.css", themeCss);
        LOGGER.debug("Spark-Swagger: CSS Theme successfully applied");
    }

    private String readFile(String name, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(SwaggerHammer.getUiFolder() + name, new String[0]));
        return new String(encoded, encoding);
    }

    private void saveFile(String fileName, String content) throws IOException {
        File file = new File(SwaggerHammer.getUiFolder() + fileName);
        file.delete();
        FileWriter f2 = new FileWriter(file, false);
        f2.write(content);
        f2.close();
        LOGGER.debug("Spark-Swagger: Swagger UI file " + fileName + " successfully saved");
    }

    public static String getUiFolder() {
        return System.getProperty("java.io.tmpdir") + "/swagger-ui/";
    }

    private void createDir(String path) {
        File uiFolder = new File(path);
        if (!uiFolder.exists()) {
            uiFolder.mkdir();
        }
    }

    private String decorateIndex(Config config) {
        LOGGER.debug("Spark-Swagger: Start decorating index.html according to ui configurations");
        String indexTemplate = UiTemplates.indexTemplate();
        int scriptStartIndex = indexTemplate.indexOf("window.onload");
        int scriptEndIndex = indexTemplate.indexOf("</script>", scriptStartIndex);
        String currentScript = indexTemplate.substring(scriptStartIndex, scriptEndIndex);
        String scriptTemplate = UiTemplates.scriptTemplate();
        scriptTemplate = this.setStringProperty(scriptTemplate, "docExpansion", config.getString("spark-swagger.docExpansion"), "list");
        scriptTemplate = this.setPrimitiveProperty(scriptTemplate, "deepLinking", config.getString("spark-swagger.deepLinking"), false);
        scriptTemplate = this.setPrimitiveProperty(scriptTemplate, "displayOperationId", config.getString("spark-swagger.displayOperationId"), false);
        scriptTemplate = this.setPrimitiveProperty(scriptTemplate, "defaultModelsExpandDepth", config.getString("spark-swagger.defaultModelsExpandDepth"), 1);
        scriptTemplate = this.setPrimitiveProperty(scriptTemplate, "defaultModelExpandDepth", config.getString("spark-swagger.defaultModelExpandDepth"), 1);
        scriptTemplate = this.setStringProperty(scriptTemplate, "defaultModelRendering", config.getString("spark-swagger.defaultModelRendering"), "example");
        scriptTemplate = this.setPrimitiveProperty(scriptTemplate, "displayRequestDuration", config.getString("spark-swagger.displayRequestDuration"), false);
        scriptTemplate = this.setPrimitiveProperty(scriptTemplate, "filter", config.getString("spark-swagger.filter"), false);
        scriptTemplate = this.setStringProperty(scriptTemplate, "operationsSorter", config.getString("spark-swagger.operationsSorter"), "alpha");
        scriptTemplate = this.setPrimitiveProperty(scriptTemplate, "showExtensions", config.getString("spark-swagger.showExtensions"), false);
        scriptTemplate = this.setPrimitiveProperty(scriptTemplate, "showCommonExtensions", config.getString("spark-swagger.showCommonExtensions"), false);
        scriptTemplate = this.setStringProperty(scriptTemplate, "tagsSorter", config.getString("spark-swagger.tagsSorter"), "alpha");
        LOGGER.debug("Spark-Swagger: index.html successfully decorated");
        return indexTemplate.replace(currentScript, scriptTemplate);
    }

    private String setStringProperty(String scriptTemplate, String propertyName, String value, String defaultValue) {
        scriptTemplate = value != null ? this.replaceProperty(scriptTemplate, propertyName, value.toLowerCase(), true) : this.replaceProperty(scriptTemplate, propertyName, defaultValue, true);
        return scriptTemplate;
    }

    private String setPrimitiveProperty(String scriptTemplate, String propertyName, Object value, Object defaultValue) {
        scriptTemplate = value != null ? this.replaceProperty(scriptTemplate, propertyName, value.toString(), false) : this.replaceProperty(scriptTemplate, propertyName, defaultValue.toString(), false);
        return scriptTemplate;
    }

    private String replaceProperty(String script, String property, String newValue, boolean isString) {
        int propertyIndex;
        if (newValue == null) {
            newValue = "null";
        }
        if (property != null && (propertyIndex = script.indexOf(property)) != -1 && script.indexOf(":", propertyIndex) != -1) {
            String propertyValue = script.substring(script.indexOf(":", propertyIndex) + 1, script.indexOf(",", propertyIndex)).trim();
            script = isString && !newValue.equals("null") ? (newValue.isEmpty() ? this.replace(script, property, propertyValue, "null") : this.replace(script, property, propertyValue, "'" + newValue + "'")) : this.replace(script, property, propertyValue, newValue);
        }
        return script;
    }

    private String replace(String script, String property, String oldValue, String newValue) {
        String oldConf = property + ": " + oldValue;
        String newConf = property + ": " + newValue;
        return script.replace(oldConf, newConf);
    }
}

