/*
 * Decompiled with CFR 0.152.
 */
package smartadapter.internal.utils;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.jvm.KTypesJvm;
import org.jetbrains.annotations.NotNull;
import smartadapter.internal.exception.ConstructorNotFoundException;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J9\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u001a\u0010\u0007\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\b\"\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\tJ1\u0010\n\u001a\u00020\u00012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\u0016\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\b\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006J\u0012\u0010\u0010\u001a\u00020\u000f2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0011\u00a8\u0006\u0012"}, d2={"Lsmartadapter/internal/utils/ReflectionUtils;", "", "()V", "getConstructor", "Lkotlin/reflect/KFunction;", "clazz", "Lkotlin/reflect/KClass;", "validConstructorClasses", "", "(Lkotlin/reflect/KClass;[Lkotlin/reflect/KClass;)Lkotlin/reflect/KFunction;", "invokeConstructor", "constructor", "args", "(Lkotlin/reflect/KFunction;[Ljava/lang/Object;)Ljava/lang/Object;", "isInnerClass", "", "isStatic", "Ljava/lang/Class;", "smartadapter_release"})
public final class ReflectionUtils {
    public static final ReflectionUtils INSTANCE;

    @NotNull
    public final KFunction<Object> getConstructor(@NotNull KClass<?> clazz, KClass<?> ... validConstructorClasses) throws ConstructorNotFoundException {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull(validConstructorClasses, (String)"validConstructorClasses");
        KClass<?>[] kClassArray = validConstructorClasses;
        boolean bl = false;
        if (kClassArray.length == 0) {
            throw (Throwable)new IllegalArgumentException("No validConstructorClasses passed");
        }
        for (KFunction constructor : clazz.getConstructors()) {
            int targetParameterIndex;
            int n = targetParameterIndex = this.isInnerClass(clazz) ? 1 : 0;
            if (constructor.getParameters().size() != 1 + targetParameterIndex) continue;
            KParameter constructorParameter = (KParameter)constructor.getParameters().get(targetParameterIndex);
            for (KClass<?> validConstructorClass : validConstructorClasses) {
                if (!Intrinsics.areEqual(validConstructorClass, (Object)KTypesJvm.getJvmErasure((KType)constructorParameter.getType()))) continue;
                return constructor;
            }
        }
        throw (Throwable)new ConstructorNotFoundException(clazz.getClass());
    }

    @NotNull
    public final Object invokeConstructor(@NotNull KFunction<? extends Object> constructor, Object ... args) throws Exception {
        Intrinsics.checkParameterIsNotNull(constructor, (String)"constructor");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        return constructor.call(Arrays.copyOf(args, args.length));
    }

    public final boolean isStatic(@NotNull Class<?> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        return Modifier.isStatic(clazz.getModifiers());
    }

    public final boolean isInnerClass(@NotNull KClass<?> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        return clazz.isInner();
    }

    private ReflectionUtils() {
    }

    static {
        ReflectionUtils reflectionUtils;
        INSTANCE = reflectionUtils = new ReflectionUtils();
    }
}

