/*
 * Decompiled with CFR 0.152.
 */
package smartadapter.widget;

import android.graphics.Canvas;
import android.view.View;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.RecyclerView;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import smartadapter.viewholder.SmartViewHolder;
import smartadapter.widget.BasicSwipeExtension;
import smartadapter.widget.SwipeExtension;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000b\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u0018\u001a\u00020\u0004H\u0016J@\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u0004H\u0016J \u0010!\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0007H\u0016J\u0018\u0010#\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000bH\u0016J\u0010\u0010$\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016JW\u0010%\u001a\u00020\u000e2M\u0010\u0005\u001aI\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012&\u0012$0\u000bj\u0011`\f\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\r\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\u0006j\u0002`\u000fH\u0016J\u0010\u0010&\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J \u0010'\u001a\u00020\u000e2\u0016\u0010\u0011\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u00130\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000RU\u0010\u0005\u001aI\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012&\u0012$0\u000bj\u0011`\f\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\r\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\u0006j\u0002`\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lsmartadapter/widget/BasicSwipeExtension;", "Lsmartadapter/widget/SwipeExtension;", "()V", "longPressDragEnabled", "", "onItemSwipedListener", "Lkotlin/Function2;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "Lkotlin/ParameterName;", "name", "viewHolder", "", "Lsmartadapter/widget/Direction;", "direction", "", "Lsmartadapter/widget/OnItemSwipedListener;", "swipeFlags", "viewHolderTypes", "", "Lkotlin/reflect/KClass;", "Lsmartadapter/viewholder/SmartViewHolder;", "getMovementFlags", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "isLongPressDragEnabled", "onChildDraw", "canvas", "Landroid/graphics/Canvas;", "dX", "", "dY", "actionState", "isCurrentlyActive", "onMove", "target", "onSwiped", "setLongPressDragEnabled", "setOnItemSwipedListener", "setSwipeFlags", "setViewHolderTypes", "smartadapter_release"})
public class BasicSwipeExtension
extends SwipeExtension {
    private boolean longPressDragEnabled;
    private int swipeFlags = 12;
    private List<? extends KClass<SmartViewHolder<?>>> viewHolderTypes = CollectionsKt.listOf((Object)Reflection.getOrCreateKotlinClass(SmartViewHolder.class));
    private Function2<? super RecyclerView.ViewHolder, ? super Integer, Unit> onItemSwipedListener = onItemSwipedListener.1.INSTANCE;

    public int getMovementFlags(@NotNull RecyclerView recyclerView, @NotNull RecyclerView.ViewHolder viewHolder) {
        Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkParameterIsNotNull((Object)viewHolder, (String)"viewHolder");
        int swipeFlags = 0;
        for (KClass<SmartViewHolder<?>> viewHolderType : this.viewHolderTypes) {
            if (!JvmClassMappingKt.getJavaClass(viewHolderType).isAssignableFrom(viewHolder.getClass())) continue;
            swipeFlags = this.swipeFlags;
            break;
        }
        return ItemTouchHelper.Callback.makeMovementFlags((int)0, (int)swipeFlags);
    }

    public boolean onMove(@NotNull RecyclerView recyclerView, @NotNull RecyclerView.ViewHolder viewHolder, @NotNull RecyclerView.ViewHolder target) {
        Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkParameterIsNotNull((Object)viewHolder, (String)"viewHolder");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        return false;
    }

    public void onSwiped(@NotNull RecyclerView.ViewHolder viewHolder, int direction) {
        Intrinsics.checkParameterIsNotNull((Object)viewHolder, (String)"viewHolder");
        this.onItemSwipedListener.invoke((Object)viewHolder, (Object)direction);
    }

    public boolean isLongPressDragEnabled() {
        return this.longPressDragEnabled;
    }

    public void onChildDraw(@NotNull Canvas canvas, @NotNull RecyclerView recyclerView, @NotNull RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkParameterIsNotNull((Object)viewHolder, (String)"viewHolder");
        if (actionState == 1) {
            float f = 1.0f;
            boolean bl = false;
            float f2 = Math.abs(dX);
            float alpha = f - f2 / (float)recyclerView.getWidth();
            View view = viewHolder.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"viewHolder.itemView");
            view.setAlpha(alpha);
        }
        super.onChildDraw(canvas, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
    }

    @Override
    public void setSwipeFlags(int swipeFlags) {
        this.swipeFlags = swipeFlags;
    }

    @Override
    public void setLongPressDragEnabled(boolean longPressDragEnabled) {
        this.longPressDragEnabled = longPressDragEnabled;
    }

    @Override
    public void setViewHolderTypes(@NotNull List<? extends KClass<SmartViewHolder<?>>> viewHolderTypes) {
        Intrinsics.checkParameterIsNotNull(viewHolderTypes, (String)"viewHolderTypes");
        this.viewHolderTypes = viewHolderTypes;
    }

    @Override
    public void setOnItemSwipedListener(@NotNull Function2<? super RecyclerView.ViewHolder, ? super Integer, Unit> onItemSwipedListener2) {
        Intrinsics.checkParameterIsNotNull(onItemSwipedListener2, (String)"onItemSwipedListener");
        this.onItemSwipedListener = onItemSwipedListener2;
    }
}

