/*
 * Decompiled with CFR 0.152.
 */
package smartadapter.internal.mapper;

import android.util.SparseArray;
import android.view.View;
import io.github.manneohlund.smartrecycleradapter.R;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import smartadapter.internal.mapper.ViewEventBinderProvider;
import smartadapter.internal.utils.ViewEventValidator;
import smartadapter.listener.OnViewEventListener;
import smartadapter.viewholder.SmartViewHolder;
import smartadapter.viewholder.ViewEventListenerHolder;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tJ\u0012\u0010\u0011\u001a\u00020\u000f2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0006J*\u0010\u0011\u001a\u00020\u000f2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00062\u0014\u0010\u0013\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0018\u00010\bH\u0002R9\u0010\u0003\u001a*\u0012\u0014\u0012\u0012\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005j\u0002`\u0007\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\b0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lsmartadapter/internal/mapper/ViewEventMapper;", "", "()V", "viewEventListenerMap", "Ljava/util/HashMap;", "Lkotlin/reflect/KClass;", "Lsmartadapter/viewholder/SmartViewHolder;", "Lsmartadapter/SmartViewHolderType;", "Landroid/util/SparseArray;", "Lsmartadapter/listener/OnViewEventListener;", "getViewEventListenerMap", "()Ljava/util/HashMap;", "viewEventListenerMapperProvider", "Lsmartadapter/internal/mapper/ViewEventBinderProvider;", "addViewEventListener", "", "viewEventListener", "mapViewEventWith", "smartViewHolder", "viewIdviewEventIdMap", "smartadapter_release"})
public final class ViewEventMapper {
    @NotNull
    private final HashMap<KClass<? extends SmartViewHolder<?>>, SparseArray<SparseArray<OnViewEventListener>>> viewEventListenerMap = new HashMap();
    private final ViewEventBinderProvider viewEventListenerMapperProvider = new ViewEventBinderProvider();

    @NotNull
    public final HashMap<KClass<? extends SmartViewHolder<?>>, SparseArray<SparseArray<OnViewEventListener>>> getViewEventListenerMap() {
        return this.viewEventListenerMap;
    }

    public final void addViewEventListener(@NotNull OnViewEventListener viewEventListener) {
        Intrinsics.checkParameterIsNotNull((Object)viewEventListener, (String)"viewEventListener");
        if (!ViewEventValidator.INSTANCE.isViewEventIdValid(viewEventListener.getViewEventId())) {
            String string;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "Invalid view event id (%d) for ViewHolder (%s)";
            Object[] objectArray = new Object[]{viewEventListener.getViewEventId(), viewEventListener.getViewHolderType()};
            boolean bl = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
            String string4 = string = string3;
            throw (Throwable)new RuntimeException(string4);
        }
        SparseArray mapper = null;
        mapper = this.viewEventListenerMap.get(viewEventListener.getViewHolderType());
        if (mapper == null) {
            mapper = new SparseArray();
        }
        if (mapper.indexOfKey(viewEventListener.getViewId()) < 0) {
            SparseArray viewEventAndListenerMap = new SparseArray();
            viewEventAndListenerMap.put(viewEventListener.getViewEventId(), (Object)viewEventListener);
            mapper.put(viewEventListener.getViewId(), (Object)viewEventAndListenerMap);
        }
        ((SparseArray)mapper.get(viewEventListener.getViewId())).put(viewEventListener.getViewEventId(), (Object)viewEventListener);
        ((Map)this.viewEventListenerMap).put(viewEventListener.getViewHolderType(), mapper);
    }

    public final void mapViewEventWith(@NotNull SmartViewHolder<?> smartViewHolder) {
        Intrinsics.checkParameterIsNotNull(smartViewHolder, (String)"smartViewHolder");
        this.mapViewEventWith(smartViewHolder, this.viewEventListenerMap.get(Reflection.getOrCreateKotlinClass(SmartViewHolder.class)));
        Map map = this.viewEventListenerMap;
        boolean bl = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            boolean bl2 = false;
            KClass key = (KClass)entry2.getKey();
            entry2 = entry;
            bl2 = false;
            SparseArray value = (SparseArray)entry2.getValue();
            boolean isNotOfSmartViewHolder = Intrinsics.areEqual((Object)key, (Object)Reflection.getOrCreateKotlinClass(SmartViewHolder.class)) ^ true;
            boolean isTargetClass = JvmClassMappingKt.getJavaClass((KClass)key).isAssignableFrom(smartViewHolder.getClass());
            if (!isNotOfSmartViewHolder || !isTargetClass) continue;
            this.mapViewEventWith(smartViewHolder, (SparseArray<SparseArray<OnViewEventListener>>)value);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void mapViewEventWith(SmartViewHolder<?> smartViewHolder, SparseArray<SparseArray<OnViewEventListener>> viewIdviewEventIdMap) {
        if (viewIdviewEventIdMap != null) {
            int n = 0;
            int n2 = viewIdviewEventIdMap.size();
            while (n < n2) {
                void i;
                SparseArray eventIdAndListener = (SparseArray)viewIdviewEventIdMap.valueAt((int)i);
                int n3 = 0;
                int n4 = eventIdAndListener.size();
                while (n3 < n4) {
                    View targetView;
                    void j;
                    int viewId = viewIdviewEventIdMap.keyAt((int)i);
                    int viewEventId = eventIdAndListener.keyAt((int)j);
                    OnViewEventListener viewEventListener = (OnViewEventListener)eventIdAndListener.valueAt((int)j);
                    if (viewId == R.id.undefined && viewEventId == R.id.undefined) {
                        SmartViewHolder<?> smartViewHolder2 = smartViewHolder;
                        if (!(smartViewHolder2 instanceof ViewEventListenerHolder)) {
                            smartViewHolder2 = null;
                        }
                        if ((ViewEventListenerHolder)((Object)smartViewHolder2) != null) {
                            ViewEventListenerHolder viewEventListenerHolder;
                            boolean bl = false;
                            boolean bl2 = false;
                            ViewEventListenerHolder it = viewEventListenerHolder;
                            boolean bl3 = false;
                            OnViewEventListener onViewEventListener2 = viewEventListener;
                            Intrinsics.checkExpressionValueIsNotNull((Object)onViewEventListener2, (String)"viewEventListener");
                            it.setViewEventListener(onViewEventListener2);
                        }
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)smartViewHolder.itemView, (String)"smartViewHolder.itemView");
                    if (viewId != R.id.undefined) {
                        View view = smartViewHolder.itemView.findViewById(viewId);
                        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"smartViewHolder.itemView.findViewById(viewId)");
                        targetView = view;
                    }
                    OnViewEventListener onViewEventListener3 = viewEventListener;
                    Intrinsics.checkExpressionValueIsNotNull((Object)onViewEventListener3, (String)"viewEventListener");
                    this.viewEventListenerMapperProvider.bind(smartViewHolder, targetView, onViewEventListener3, viewEventId);
                    ++j;
                }
                ++i;
            }
        }
    }
}

