/*
 * Decompiled with CFR 0.152.
 */
package smartadapter.widget;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.RecyclerView;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import smartadapter.SmartExtensionBuilder;
import smartadapter.SmartRecyclerAdapter;
import smartadapter.listener.OnItemSwipedListener;
import smartadapter.viewholder.SmartAdapterHolder;
import smartadapter.viewholder.SmartViewHolder;
import smartadapter.widget.BasicSwipeExtension;
import smartadapter.widget.SwipeExtension;

public class SwipeExtensionBuilder
implements SmartExtensionBuilder<SwipeExtension, SwipeExtensionBuilder> {
    private SwipeExtension swipeExtension;
    private int swipeFlags = 12;
    private boolean longPressDragEnabled;
    private List<Class<? extends SmartViewHolder>> viewHolderTypes = Collections.singletonList(SmartViewHolder.class);
    private SmartRecyclerAdapter smartRecyclerAdapter;
    private RecyclerView recyclerView;
    private OnItemSwipedListener onItemSwipedListener;

    public SwipeExtensionBuilder() {
        this.onItemSwipedListener = (oldViewHolder, targetViewHolder) -> {};
        this.swipeExtension = new BasicSwipeExtension();
    }

    public SwipeExtensionBuilder(@NonNull SwipeExtension swipeExtension) {
        this.onItemSwipedListener = (oldViewHolder, targetViewHolder) -> {};
        this.swipeExtension = swipeExtension;
    }

    @Override
    public SwipeExtensionBuilder setSmartRecyclerAdapter(@NonNull SmartRecyclerAdapter smartRecyclerAdapter) {
        this.smartRecyclerAdapter = smartRecyclerAdapter;
        return this;
    }

    @Override
    public SwipeExtensionBuilder setRecyclerView(@NonNull RecyclerView recyclerView) {
        this.recyclerView = recyclerView;
        return this;
    }

    public SwipeExtensionBuilder setOnItemSwipedListener(@NonNull OnItemSwipedListener onItemSwipedListener) {
        this.onItemSwipedListener = onItemSwipedListener;
        return this;
    }

    public SwipeExtensionBuilder setSwipeFlags(int swipeFlags) {
        this.swipeFlags = swipeFlags;
        return this;
    }

    public SwipeExtensionBuilder setLongPressDragEnabled(boolean longPressDragEnabled) {
        this.longPressDragEnabled = longPressDragEnabled;
        return this;
    }

    @SafeVarargs
    public final SwipeExtensionBuilder setViewHolderTypes(Class<? extends SmartViewHolder> ... viewHolderTypes) {
        this.viewHolderTypes = Arrays.asList(viewHolderTypes);
        return this;
    }

    @Override
    public SwipeExtension build() {
        if (this.swipeExtension instanceof SmartAdapterHolder) {
            ((SmartAdapterHolder)((Object)this.swipeExtension)).setSmartRecyclerAdapter(this.smartRecyclerAdapter);
        }
        this.swipeExtension.setSwipeFlags(this.swipeFlags);
        this.swipeExtension.setLongPressDragEnabled(this.longPressDragEnabled);
        this.swipeExtension.setViewHolderTypes(this.viewHolderTypes);
        this.swipeExtension.setOnItemSwipedListener(this.onItemSwipedListener);
        ItemTouchHelper touchHelper = new ItemTouchHelper((ItemTouchHelper.Callback)this.swipeExtension);
        touchHelper.attachToRecyclerView(this.recyclerView);
        return this.swipeExtension;
    }
}

