/*
 * Decompiled with CFR 0.152.
 */
package smartadapter.widget;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.RecyclerView;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import smartadapter.SmartExtensionBuilder;
import smartadapter.SmartRecyclerAdapter;
import smartadapter.listener.OnItemMovedListener;
import smartadapter.viewholder.SmartAdapterHolder;
import smartadapter.viewholder.SmartViewHolder;
import smartadapter.widget.BasicDragAndDropExtension;
import smartadapter.widget.DragAndDropExtension;

public class DragAndDropExtensionBuilder
implements SmartExtensionBuilder<DragAndDropExtension, DragAndDropExtensionBuilder> {
    private DragAndDropExtension dragAndDropExtension;
    private SmartRecyclerAdapter smartRecyclerAdapter;
    private RecyclerView recyclerView;
    private int dragFlags;
    private boolean longPressDragEnabled;
    private List<Class<? extends SmartViewHolder>> viewHolderTypes = Collections.singletonList(SmartViewHolder.class);
    private OnItemMovedListener onItemMovedListener;

    public DragAndDropExtensionBuilder() {
        this.onItemMovedListener = (oldViewHolder, targetViewHolder) -> {};
        this.dragAndDropExtension = new BasicDragAndDropExtension();
    }

    public DragAndDropExtensionBuilder(DragAndDropExtension dragAndDropExtension) {
        this.onItemMovedListener = (oldViewHolder, targetViewHolder) -> {};
        this.dragAndDropExtension = dragAndDropExtension;
    }

    @Override
    public DragAndDropExtensionBuilder setSmartRecyclerAdapter(@NonNull SmartRecyclerAdapter smartRecyclerAdapter) {
        this.smartRecyclerAdapter = smartRecyclerAdapter;
        return this;
    }

    @Override
    public DragAndDropExtensionBuilder setRecyclerView(@NonNull RecyclerView recyclerView) {
        this.recyclerView = recyclerView;
        return this;
    }

    public DragAndDropExtensionBuilder setDragFlags(int dragFlags) {
        this.dragFlags = dragFlags;
        return this;
    }

    public DragAndDropExtensionBuilder setLongPressDragEnabled(boolean longPressDragEnabled) {
        this.longPressDragEnabled = longPressDragEnabled;
        return this;
    }

    @SafeVarargs
    public final DragAndDropExtensionBuilder setViewHolderTypes(Class<? extends SmartViewHolder> ... viewHolderTypes) {
        this.viewHolderTypes = Arrays.asList(viewHolderTypes);
        return this;
    }

    public DragAndDropExtensionBuilder setOnItemMovedListener(@NonNull OnItemMovedListener onItemMovedListener) {
        this.onItemMovedListener = onItemMovedListener;
        return this;
    }

    @Override
    public DragAndDropExtension build() {
        if (this.dragAndDropExtension instanceof SmartAdapterHolder) {
            ((SmartAdapterHolder)((Object)this.dragAndDropExtension)).setSmartRecyclerAdapter(this.smartRecyclerAdapter);
        }
        this.dragAndDropExtension.setLongPressDragEnabled(this.longPressDragEnabled);
        this.dragAndDropExtension.setDragFlags(this.dragFlags);
        this.dragAndDropExtension.setViewHolderTypes(this.viewHolderTypes);
        this.dragAndDropExtension.setOnItemMovedListener(this.onItemMovedListener);
        ItemTouchHelper touchHelper = new ItemTouchHelper((ItemTouchHelper.Callback)this.dragAndDropExtension);
        this.dragAndDropExtension.setTouchHelper(touchHelper);
        touchHelper.attachToRecyclerView(this.recyclerView);
        this.dragAndDropExtension.setupDragAndDrop(this.recyclerView);
        return this.dragAndDropExtension;
    }
}

