/*
 * Decompiled with CFR 0.152.
 */
package smartadapter.widget;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import java.util.List;
import smartadapter.SmartRecyclerAdapter;
import smartadapter.widget.DiffUtilExtension;

public class DefaultDiffUtilExtension
extends DiffUtilExtension {
    private SmartRecyclerAdapter smartRecyclerAdapter;
    private DiffUtilExtension.DiffPredicate diffPredicate;
    private List oldList;
    private List newList;

    public int getOldListSize() {
        return this.oldList.size();
    }

    public int getNewListSize() {
        return this.newList.size();
    }

    public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
        return this.diffPredicate.areItemsTheSame(this.oldList.get(oldItemPosition), this.newList.get(newItemPosition));
    }

    public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
        return this.diffPredicate.areContentsTheSame(this.oldList.get(oldItemPosition), this.newList.get(newItemPosition));
    }

    @Override
    public void setSmartRecyclerAdapter(@NonNull SmartRecyclerAdapter smartRecyclerAdapter) {
        this.smartRecyclerAdapter = smartRecyclerAdapter;
    }

    @Override
    public void setDiffPredicate(@NonNull DiffUtilExtension.DiffPredicate diffPredicate) {
        this.diffPredicate = diffPredicate;
    }

    @Override
    public void diffSwapList(@NonNull List newList) {
        this.oldList = this.smartRecyclerAdapter.getItems();
        this.newList = newList;
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)this);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)this.smartRecyclerAdapter);
        this.smartRecyclerAdapter.setItems(newList, false);
    }
}

