/*
 * Decompiled with CFR 0.152.
 */
package smartadapter.widget;

import android.graphics.Canvas;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import java.util.Collections;
import java.util.List;
import smartadapter.listener.OnItemSwipedListener;
import smartadapter.viewholder.SmartViewHolder;
import smartadapter.widget.SwipeExtension;

public class BasicSwipeExtension
extends SwipeExtension {
    private boolean longPressDragEnabled;
    private int swipeFlags = 12;
    private List<Class<? extends SmartViewHolder>> viewHolderTypes = Collections.singletonList(SmartViewHolder.class);
    private OnItemSwipedListener onItemSwipedListener = (oldViewHolder, targetViewHolder) -> {};

    public int getMovementFlags(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder) {
        int swipeFlags = 0;
        for (Class<? extends SmartViewHolder> viewHolderType : this.viewHolderTypes) {
            if (!viewHolderType.isAssignableFrom(viewHolder.getClass())) continue;
            swipeFlags = this.swipeFlags;
            break;
        }
        return BasicSwipeExtension.makeMovementFlags((int)0, (int)swipeFlags);
    }

    public boolean onMove(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder, @NonNull RecyclerView.ViewHolder target) {
        return false;
    }

    public void onSwiped(@NonNull RecyclerView.ViewHolder viewHolder, int direction) {
        this.onItemSwipedListener.onSwiped(viewHolder, direction);
    }

    public boolean isLongPressDragEnabled() {
        return this.longPressDragEnabled;
    }

    public void onChildDraw(@NonNull Canvas canvas, @NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
        if (actionState == 1) {
            float alpha = 1.0f - Math.abs(dX) / (float)recyclerView.getWidth();
            viewHolder.itemView.setAlpha(alpha);
        }
        super.onChildDraw(canvas, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
    }

    @Override
    public void setSwipeFlags(int swipeFlags) {
        this.swipeFlags = swipeFlags;
    }

    @Override
    public void setLongPressDragEnabled(boolean longPressDragEnabled) {
        this.longPressDragEnabled = longPressDragEnabled;
    }

    @Override
    public void setViewHolderTypes(@NonNull List<Class<? extends SmartViewHolder>> viewHolderTypes) {
        this.viewHolderTypes = viewHolderTypes;
    }

    @Override
    public void setOnItemSwipedListener(@NonNull OnItemSwipedListener onItemSwipedListener) {
        this.onItemSwipedListener = onItemSwipedListener;
    }
}

