/*
 * Decompiled with CFR 0.152.
 */
package smartadapter.widget;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.RecyclerView;
import java.util.Collections;
import java.util.List;
import smartadapter.listener.OnItemMovedListener;
import smartadapter.viewholder.SmartViewHolder;
import smartadapter.widget.DragAndDropExtension;

public class BasicDragAndDropExtension
extends DragAndDropExtension {
    private boolean longPressDragEnabled;
    private int dragFlags;
    private List<Class<? extends SmartViewHolder>> viewHolderTypes = Collections.singletonList(SmartViewHolder.class);
    private ItemTouchHelper touchHelper;
    private OnItemMovedListener onItemMovedListener = (oldViewHolder, targetViewHolder) -> {};

    public int getMovementFlags(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder) {
        return BasicDragAndDropExtension.makeMovementFlags((int)this.dragFlags, (int)0);
    }

    public boolean onMove(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder, @NonNull RecyclerView.ViewHolder target) {
        for (Class<? extends SmartViewHolder> viewHolderType : this.viewHolderTypes) {
            if (!viewHolderType.isAssignableFrom(target.getClass()) || !viewHolder.getClass().equals(target.getClass())) continue;
            this.onItemMovedListener.onMoved(viewHolder, target);
            return true;
        }
        return false;
    }

    public void onSwiped(@NonNull RecyclerView.ViewHolder viewHolder, int direction) {
    }

    public boolean isLongPressDragEnabled() {
        return this.longPressDragEnabled;
    }

    @Override
    public void setLongPressDragEnabled(boolean longPressDragEnabled) {
        this.longPressDragEnabled = longPressDragEnabled;
    }

    @Override
    public void setDragFlags(int dragFlags) {
        this.dragFlags = dragFlags;
    }

    @Override
    public void setTouchHelper(@NonNull ItemTouchHelper touchHelper) {
        this.touchHelper = touchHelper;
    }

    public ItemTouchHelper getTouchHelper() {
        return this.touchHelper;
    }

    @Override
    @SuppressLint(value={"ClickableViewAccessibility"})
    protected void setupDragAndDrop(@NonNull RecyclerView recyclerView) {
        if (this.dragFlags == 0) {
            int gridDragFlags = 15;
            int linearDragFlags = 3;
            this.dragFlags = recyclerView.getLayoutManager() instanceof GridLayoutManager ? gridDragFlags : linearDragFlags;
        }
    }

    @Override
    public void setViewHolderTypes(@NonNull List<Class<? extends SmartViewHolder>> viewHolderTypes) {
        this.viewHolderTypes = viewHolderTypes;
    }

    @Override
    public void setOnItemMovedListener(@NonNull OnItemMovedListener onItemMovedListener) {
        this.onItemMovedListener = onItemMovedListener;
    }
}

