/*
 * Decompiled with CFR 0.152.
 */
package smartadapter.widget;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import java.util.HashSet;
import smartadapter.SmartRecyclerAdapter;
import smartadapter.viewholder.DraggableViewHolder;
import smartadapter.viewholder.SmartAdapterHolder;
import smartadapter.widget.BasicDragAndDropExtension;

public class AutoDragAndDropExtension
extends BasicDragAndDropExtension
implements SmartAdapterHolder {
    private SmartRecyclerAdapter smartRecyclerAdapter;
    private HashSet<RecyclerView.ViewHolder> draggableViews = new HashSet();

    @Override
    public boolean onMove(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder, @NonNull RecyclerView.ViewHolder target) {
        boolean moved = super.onMove(recyclerView, viewHolder, target);
        if (moved) {
            int oldPosition = viewHolder.getAdapterPosition();
            int newPosition = target.getAdapterPosition();
            Object targetItem = this.smartRecyclerAdapter.getItems().get(oldPosition);
            this.smartRecyclerAdapter.getItems().remove(oldPosition);
            this.smartRecyclerAdapter.getItems().add(newPosition, targetItem);
            this.smartRecyclerAdapter.notifyItemMoved(oldPosition, newPosition);
        }
        return moved;
    }

    @Override
    @SuppressLint(value={"ClickableViewAccessibility"})
    protected void setupDragAndDrop(@NonNull RecyclerView recyclerView) {
        super.setupDragAndDrop(recyclerView);
        if (!this.isLongPressDragEnabled()) {
            this.smartRecyclerAdapter.addOnViewAttachedToWindowListener(viewHolder -> {
                if (viewHolder instanceof DraggableViewHolder && !this.draggableViews.contains(viewHolder)) {
                    this.draggableViews.add(viewHolder);
                    ((DraggableViewHolder)viewHolder).getDraggableView().setOnTouchListener((v, event) -> {
                        if (event.getActionMasked() == 0) {
                            this.getTouchHelper().startDrag(viewHolder);
                        }
                        return false;
                    });
                }
            });
        }
    }

    @Override
    public void setSmartRecyclerAdapter(@NonNull SmartRecyclerAdapter smartRecyclerAdapter) {
        this.smartRecyclerAdapter = smartRecyclerAdapter;
    }
}

