/*
 * Decompiled with CFR 0.152.
 */
package smartadapter.state;

import java.util.TreeSet;
import smartadapter.SmartRecyclerAdapter;
import smartadapter.state.SmartStateHolder;

public class SelectionStateHolder
implements SmartStateHolder {
    protected SmartRecyclerAdapter smartRecyclerAdapter;
    protected TreeSet<Integer> enabledAdapterPositions = new TreeSet();

    @Override
    public void enable(int position) {
        this.enabledAdapterPositions.add(position);
    }

    @Override
    public void disable(int position) {
        this.enabledAdapterPositions.remove(position);
    }

    @Override
    public void toggle(int position) {
        if (this.enabledAdapterPositions.contains(position)) {
            this.disable(position);
        } else {
            this.enable(position);
        }
        this.smartRecyclerAdapter.smartNotifyItemChanged(position);
    }

    @Override
    public void clear() {
        this.enabledAdapterPositions.clear();
    }

    public boolean isSelected(int position) {
        return this.enabledAdapterPositions.contains(position);
    }

    public TreeSet<Integer> getSelectedItems() {
        return this.enabledAdapterPositions;
    }

    public int getSelectedItemsCount() {
        return this.enabledAdapterPositions.size();
    }

    public void setSmartRecyclerAdapter(SmartRecyclerAdapter smartRecyclerAdapter) {
        this.smartRecyclerAdapter = smartRecyclerAdapter;
    }

    public void removeSelections() {
        for (int position : this.enabledAdapterPositions.descendingSet()) {
            this.smartRecyclerAdapter.removeItem(position);
        }
        this.enabledAdapterPositions.clear();
    }
}

