/*
 * Decompiled with CFR 0.152.
 */
package smartadapter.internal.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import smartadapter.internal.exception.ConstructorNotFoundException;

public class ReflectionUtils {
    public static Constructor getConstructor(Class<?> clazz, Class<?> ... validConstructorClasses) throws ConstructorNotFoundException {
        if (validConstructorClasses.length == 0) {
            throw new IllegalArgumentException("No validConstructorClasses passed");
        }
        for (Constructor<?> constructor : clazz.getConstructors()) {
            int targetParameterIndex;
            int n = targetParameterIndex = ReflectionUtils.isNonStaticInnerClass(clazz) ? 1 : 0;
            if (constructor.getParameterTypes().length != 1 + targetParameterIndex) continue;
            Class<?> constructorParameter = constructor.getParameterTypes()[targetParameterIndex];
            for (Class<?> validConstructorClass : validConstructorClasses) {
                if (!validConstructorClass.isAssignableFrom(constructorParameter)) continue;
                return constructor;
            }
        }
        throw new ConstructorNotFoundException(clazz);
    }

    public static Object invokeConstructor(Constructor constructor, Object ... args) throws Exception {
        return constructor.newInstance(args);
    }

    public static boolean isStatic(Class clazz) {
        return Modifier.isStatic(clazz.getModifiers());
    }

    public static boolean isNonStaticInnerClass(Class clazz) {
        return clazz.getDeclaringClass() != null && !ReflectionUtils.isStatic(clazz);
    }
}

