/*
 * Decompiled with CFR 0.152.
 */
package smartadapter.internal.mapper;

import android.util.SparseArray;
import android.view.ViewGroup;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import smartadapter.SmartRecyclerAdapter;
import smartadapter.internal.mapper.ViewHolderConstructorMapper;
import smartadapter.internal.utils.ReflectionUtils;
import smartadapter.viewholder.SmartAdapterHolder;
import smartadapter.viewholder.SmartViewHolder;
import smartadapter.widget.ViewTypeResolver;

public class ViewHolderMapper {
    private final Object caller;
    private Class<? extends SmartViewHolder> smartViewHolderClass;
    private Class<? extends SmartViewHolder> viewType;
    private int smartViewHolderKey;
    private Constructor constructor;
    private final SparseArray<Class<? extends SmartViewHolder>> viewTypeMapper = new SparseArray();
    private final ViewHolderConstructorMapper viewHolderConstructorMapper = new ViewHolderConstructorMapper();
    private HashMap<String, Class<? extends SmartViewHolder>> dataTypeViewHolderMapper = new HashMap();
    private HashMap<Class<? extends SmartViewHolder>, SmartRecyclerAdapter> smartRecyclerAdapterMapper = new HashMap();

    public ViewHolderMapper(Object callerEnclosingClass) {
        this.caller = callerEnclosingClass;
    }

    public int getItemViewType(ViewTypeResolver viewTypeResolver, Object item, int position) {
        Class<? extends SmartViewHolder> clazz = this.smartViewHolderClass = viewTypeResolver == null ? null : viewTypeResolver.getViewType(item, position);
        if (this.smartViewHolderClass == null) {
            this.smartViewHolderClass = this.dataTypeViewHolderMapper.get(item.getClass().getName());
        } else {
            this.viewHolderConstructorMapper.add(this.smartViewHolderClass);
        }
        if (this.smartViewHolderClass != null) {
            this.smartViewHolderKey = this.smartViewHolderClass.getName().hashCode();
            this.viewTypeMapper.put(this.smartViewHolderKey, this.smartViewHolderClass);
            return this.smartViewHolderKey;
        }
        throw new RuntimeException(String.format("Fatal error! Mapping of ViewHolder to item '%s' does not exist", item.getClass().getName()));
    }

    public <VH extends SmartViewHolder> VH createViewHolder(ViewGroup parent, int viewType) {
        SmartViewHolder viewHolder;
        this.smartViewHolderClass = (Class)this.viewTypeMapper.get(viewType);
        this.constructor = this.viewHolderConstructorMapper.getConstructor(this.smartViewHolderClass);
        try {
            Object[] objectArray;
            if (ReflectionUtils.isNonStaticInnerClass(this.smartViewHolderClass)) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = this.caller;
                objectArray = objectArray2;
                objectArray2[1] = parent;
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = parent;
            }
            viewHolder = (SmartViewHolder)ReflectionUtils.invokeConstructor(this.constructor, objectArray);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Could not invoke constructor for '%s', '%s'", this.smartViewHolderClass.toString(), e.getMessage()), e);
        }
        SmartRecyclerAdapter smartRecyclerAdapter = this.smartRecyclerAdapterMapper.get(viewHolder.getClass());
        if (viewHolder instanceof SmartAdapterHolder && smartRecyclerAdapter != null) {
            ((SmartAdapterHolder)((Object)viewHolder)).setSmartRecyclerAdapter(smartRecyclerAdapter);
        }
        return (VH)viewHolder;
    }

    public void addMapping(Class<?> itemType, Class<? extends SmartViewHolder> viewHolderType) {
        this.dataTypeViewHolderMapper.put(itemType.getName(), viewHolderType);
        this.viewHolderConstructorMapper.add(viewHolderType);
    }

    public void setDataTypeViewHolderMapper(HashMap<String, Class<? extends SmartViewHolder>> dataTypeViewHolderMapper) {
        this.dataTypeViewHolderMapper = dataTypeViewHolderMapper;
        this.viewHolderConstructorMapper.add(dataTypeViewHolderMapper.values());
    }

    public void setSmartRecyclerAdapterMapper(HashMap<Class<? extends SmartViewHolder>, SmartRecyclerAdapter> smartRecyclerAdapterMapper) {
        this.smartRecyclerAdapterMapper = smartRecyclerAdapterMapper;
    }
}

