/*
 * Decompiled with CFR 0.152.
 */
package smartadapter.internal.mapper;

import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import androidx.annotation.NonNull;
import io.github.manneohlund.smartrecycleradapter.R;
import java.util.HashMap;
import java.util.Map;
import smartadapter.internal.mapper.ViewEventBinderProvider;
import smartadapter.internal.utils.ViewEventValidator;
import smartadapter.listener.OnViewEventListener;
import smartadapter.viewholder.SmartViewHolder;
import smartadapter.viewholder.ViewEventListenerHolder;

public class ViewEventMapper {
    private final HashMap<Class<? extends SmartViewHolder>, SparseArray<SparseArray<OnViewEventListener>>> viewEventListenerMap = new HashMap();
    private final ViewEventBinderProvider viewEventListenerMapperProvider = new ViewEventBinderProvider();

    public final void addViewEventListener(@NonNull OnViewEventListener viewEventListener) {
        if (!ViewEventValidator.isViewEventIdValid(viewEventListener.getViewEventId())) {
            throw new RuntimeException(String.format("Invalid view event id (%d) for ViewHolder (%s)", viewEventListener.getViewEventId(), viewEventListener.getViewHolderType()));
        }
        SparseArray mapper = this.viewEventListenerMap.get(viewEventListener.getViewHolderType());
        if (mapper == null) {
            mapper = new SparseArray();
        }
        if (mapper.indexOfKey(viewEventListener.getViewId()) < 0) {
            SparseArray viewEventAndListenerMap = new SparseArray();
            viewEventAndListenerMap.put(viewEventListener.getViewEventId(), (Object)viewEventListener);
            mapper.put(viewEventListener.getViewId(), (Object)viewEventAndListenerMap);
        }
        ((SparseArray)mapper.get(viewEventListener.getViewId())).put(viewEventListener.getViewEventId(), (Object)viewEventListener);
        this.viewEventListenerMap.put(viewEventListener.getViewHolderType(), (SparseArray<SparseArray<OnViewEventListener>>)mapper);
    }

    public HashMap<Class<? extends SmartViewHolder>, SparseArray<SparseArray<OnViewEventListener>>> getViewEventListenerMap() {
        return this.viewEventListenerMap;
    }

    public void mapViewEventWith(@NonNull SmartViewHolder smartViewHolder) {
        this.mapViewEventWith(smartViewHolder, this.viewEventListenerMap.get(SmartViewHolder.class));
        for (Map.Entry<Class<? extends SmartViewHolder>, SparseArray<SparseArray<OnViewEventListener>>> viewEventListenerMapEntry : this.viewEventListenerMap.entrySet()) {
            if (viewEventListenerMapEntry.getKey() == SmartViewHolder.class || !viewEventListenerMapEntry.getKey().isAssignableFrom(smartViewHolder.getClass())) continue;
            this.mapViewEventWith(smartViewHolder, viewEventListenerMapEntry.getValue());
        }
    }

    private void mapViewEventWith(@NonNull SmartViewHolder smartViewHolder, SparseArray<SparseArray<OnViewEventListener>> viewIdActionIdMap) {
        if (viewIdActionIdMap != null) {
            for (int i = 0; i < viewIdActionIdMap.size(); ++i) {
                SparseArray eventIdAndListener = (SparseArray)viewIdActionIdMap.valueAt(i);
                for (int j = 0; j < eventIdAndListener.size(); ++j) {
                    int viewId = viewIdActionIdMap.keyAt(i);
                    int viewEventId = eventIdAndListener.keyAt(j);
                    OnViewEventListener viewActionListener = (OnViewEventListener)eventIdAndListener.valueAt(j);
                    if (viewId == R.id.undefined && viewEventId == R.id.undefined) {
                        if (ViewEventListenerHolder.class.isAssignableFrom(smartViewHolder.getClass())) {
                            ((ViewEventListenerHolder)((Object)smartViewHolder)).setOnViewEventListener(viewActionListener);
                        } else {
                            Log.e((String)ViewEventMapper.class.getName(), (String)String.format("Don't forget that '%s' needs to implement '%s' in order to receive the events", smartViewHolder.getClass().getName(), ViewEventListenerHolder.class.getName()));
                        }
                    }
                    View targetView = smartViewHolder.itemView;
                    if (viewId != R.id.undefined) {
                        targetView = smartViewHolder.itemView.findViewById(viewId);
                    }
                    this.viewEventListenerMapperProvider.bind(smartViewHolder, targetView, viewActionListener, viewEventId);
                }
            }
        }
    }
}

