/*
 * Decompiled with CFR 0.152.
 */
package smartadapter.internal.mapper;

import android.util.SparseArray;
import android.view.View;
import androidx.annotation.NonNull;
import io.github.manneohlund.smartrecycleradapter.R;
import smartadapter.listener.OnItemSelectedListener;
import smartadapter.listener.OnViewEventListener;
import smartadapter.viewholder.SmartViewHolder;
import smartadapter.viewholder.StatefulViewHolder;

public class ViewEventBinderProvider {
    private SparseArray<ViewEventBinder> eventBinders = new SparseArray();

    ViewEventBinderProvider() {
        this.eventBinders.append(R.id.event_on_click, (Object)new OnClickListenerBinder());
        this.eventBinders.append(R.id.event_on_long_click, (Object)new OnLongClickListenerBinder());
        this.eventBinders.append(R.id.event_on_item_selected, (Object)new OnItemSelectedListenerBinder());
    }

    public void bind(SmartViewHolder smartViewHolder, View targetView, OnViewEventListener viewEventListener, int viewEventId) {
        if (this.eventBinders.indexOfKey(viewEventId) >= 0) {
            ((ViewEventBinder)this.eventBinders.get(viewEventId)).bindListener(smartViewHolder, targetView, viewEventListener, viewEventId);
        }
    }

    class OnItemSelectedListenerBinder
    implements ViewEventBinder {
        OnItemSelectedListenerBinder() {
        }

        @Override
        public void bindListener(@NonNull SmartViewHolder smartViewHolder, @NonNull View targetView, @NonNull OnViewEventListener viewEventListener, int viewEventId) {
            if (smartViewHolder instanceof StatefulViewHolder) {
                ((StatefulViewHolder)((Object)smartViewHolder)).setStateHolder(((OnItemSelectedListener)viewEventListener).getSelectionStateHolder());
            }
            if (((OnItemSelectedListener)viewEventListener).enableOnLongClick()) {
                targetView.setOnLongClickListener(v -> {
                    ((OnItemSelectedListener)viewEventListener).getSelectionStateHolder().toggle(smartViewHolder.getAdapterPosition());
                    viewEventListener.onViewEvent(v, viewEventId, smartViewHolder.getAdapterPosition());
                    return true;
                });
            }
            targetView.setOnClickListener(v -> {
                if (!((OnItemSelectedListener)viewEventListener).enableOnLongClick() || ((OnItemSelectedListener)viewEventListener).enableOnLongClick() && ((OnItemSelectedListener)viewEventListener).getSelectionStateHolder().getSelectedItemsCount() > 0) {
                    ((OnItemSelectedListener)viewEventListener).getSelectionStateHolder().toggle(smartViewHolder.getAdapterPosition());
                }
                viewEventListener.onViewEvent(v, viewEventId, smartViewHolder.getAdapterPosition());
            });
        }
    }

    class OnLongClickListenerBinder
    implements ViewEventBinder {
        OnLongClickListenerBinder() {
        }

        @Override
        public void bindListener(@NonNull SmartViewHolder smartViewHolder, @NonNull View targetView, @NonNull OnViewEventListener viewEventListener, int viewEventId) {
            targetView.setOnLongClickListener(v -> {
                viewEventListener.onViewEvent(v, viewEventId, smartViewHolder.getAdapterPosition());
                return true;
            });
        }
    }

    class OnClickListenerBinder
    implements ViewEventBinder {
        OnClickListenerBinder() {
        }

        @Override
        public void bindListener(@NonNull SmartViewHolder smartViewHolder, @NonNull View targetView, @NonNull OnViewEventListener viewEventListener, int viewEventId) {
            targetView.setOnClickListener(v -> viewEventListener.onViewEvent(v, viewEventId, smartViewHolder.getAdapterPosition()));
        }
    }

    static interface ViewEventBinder {
        public void bindListener(@NonNull SmartViewHolder var1, @NonNull View var2, @NonNull OnViewEventListener var3, int var4);
    }
}

