/*
 * Decompiled with CFR 0.152.
 */
package smartadapter;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.util.HashMap;
import smartadapter.SmartExtensionBuilder;
import smartadapter.SmartRecyclerAdapter;
import smartadapter.internal.factory.SmartRecyclerAdapterExtensionFactory;
import smartadapter.internal.mapper.ViewEventMapper;
import smartadapter.listener.OnItemSelectedListener;
import smartadapter.listener.OnViewEventListener;
import smartadapter.viewholder.SmartViewHolder;
import smartadapter.widget.ViewTypeResolver;

public class SmartAdapterBuilder {
    private SmartRecyclerAdapter smartRecyclerAdapter;
    private RecyclerView.LayoutManager layoutManager;
    private ViewTypeResolver viewTypeResolver;
    private HashMap<String, Class<? extends SmartViewHolder>> viewHolderMapper = new HashMap();
    private HashMap<Class<? extends SmartViewHolder>, SmartRecyclerAdapter> smartRecyclerAdapterMapper = new HashMap();
    private ViewEventMapper viewEventMapper = new ViewEventMapper();
    private SmartRecyclerAdapterExtensionFactory smartRecyclerAdapterExtensionFactory = new SmartRecyclerAdapterExtensionFactory();

    SmartAdapterBuilder(@NonNull SmartRecyclerAdapter smartRecyclerAdapter) {
        this.smartRecyclerAdapter = smartRecyclerAdapter;
    }

    public final SmartAdapterBuilder map(@NonNull Class<?> itemType, @NonNull Class<? extends SmartViewHolder> viewHolderType) {
        this.viewHolderMapper.put(itemType.getName(), viewHolderType);
        return this;
    }

    public final SmartAdapterBuilder map(@NonNull Class<? extends SmartViewHolder> viewHolderType, @NonNull SmartRecyclerAdapter smartRecyclerAdapter) {
        this.smartRecyclerAdapterMapper.put(viewHolderType, smartRecyclerAdapter);
        return this;
    }

    public final SmartAdapterBuilder setLayoutManager(@NonNull RecyclerView.LayoutManager layoutManager) {
        this.layoutManager = layoutManager;
        return this;
    }

    private RecyclerView.LayoutManager getLayoutManager(Context context) {
        if (this.layoutManager == null) {
            this.layoutManager = new LinearLayoutManager(context);
        }
        return this.layoutManager;
    }

    public final SmartAdapterBuilder setViewTypeResolver(@NonNull ViewTypeResolver viewTypeResolver) {
        this.viewTypeResolver = viewTypeResolver;
        return this;
    }

    public final SmartAdapterBuilder addViewEventListener(@NonNull OnViewEventListener viewEventListener) {
        if (viewEventListener instanceof OnItemSelectedListener) {
            ((OnItemSelectedListener)viewEventListener).getSelectionStateHolder().setSmartRecyclerAdapter(this.smartRecyclerAdapter);
            this.viewEventMapper.addViewEventListener(viewEventListener);
        } else {
            this.viewEventMapper.addViewEventListener(viewEventListener);
        }
        return this;
    }

    public final SmartAdapterBuilder addExtensionBuilder(@NonNull SmartExtensionBuilder smartExtensionBuilder) {
        this.smartRecyclerAdapterExtensionFactory.add(smartExtensionBuilder);
        return this;
    }

    public final <T> T into(RecyclerView recyclerView) {
        this.smartRecyclerAdapter.setDataTypeViewHolderMapper(this.viewHolderMapper);
        this.smartRecyclerAdapter.setSmartRecyclerAdapterMapper(this.smartRecyclerAdapterMapper);
        this.smartRecyclerAdapter.setViewTypeResolver(this.viewTypeResolver);
        this.smartRecyclerAdapter.setViewEventMapper(this.viewEventMapper);
        recyclerView.setAdapter((RecyclerView.Adapter)this.smartRecyclerAdapter);
        recyclerView.setLayoutManager(this.getLayoutManager(recyclerView.getContext()));
        this.smartRecyclerAdapterExtensionFactory.build(this.smartRecyclerAdapter, recyclerView);
        return (T)this.smartRecyclerAdapter;
    }

    public final <T> T create() {
        this.smartRecyclerAdapter.setDataTypeViewHolderMapper(this.viewHolderMapper);
        this.smartRecyclerAdapter.setSmartRecyclerAdapterMapper(this.smartRecyclerAdapterMapper);
        this.smartRecyclerAdapter.setViewTypeResolver(this.viewTypeResolver);
        this.smartRecyclerAdapter.setViewEventMapper(this.viewEventMapper);
        return (T)this.smartRecyclerAdapter;
    }
}

