/*
 * Decompiled with CFR 0.152.
 */
package smartadapter.manager;

import android.util.SparseArray;
import android.view.ViewGroup;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import smartadapter.SmartRecyclerAdapter;
import smartadapter.listener.ViewEventListener;
import smartadapter.utils.ReflectionUtils;
import smartadapter.viewholder.SmartAdapterHolder;
import smartadapter.viewholder.SmartViewHolder;
import smartadapter.viewholder.ViewEventHolder;
import smartadapter.widget.ViewTypeResolver;

public class Mapper {
    private final Object caller;
    private int identifier = 0;
    private final SparseArray<Class<? extends SmartViewHolder>> viewTypeMapper = new SparseArray();
    private final HashMap<Class, Constructor> viewHolderConstructorMapper = new HashMap();
    private HashMap<String, Class<? extends SmartViewHolder>> dataTypeViewHolderMapper = new HashMap();
    private HashMap<Class<? extends SmartViewHolder>, SmartRecyclerAdapter> smartRecyclerAdapterMapper = new HashMap();

    public Mapper(Object callerEnclosingClass) {
        this.caller = callerEnclosingClass;
    }

    public int getItemViewType(ViewTypeResolver viewTypeResolver, Object item, int position) {
        Class<? extends SmartViewHolder> viewHolder;
        Class<? extends SmartViewHolder> clazz = viewHolder = viewTypeResolver == null ? null : viewTypeResolver.getViewType(item, position);
        if (viewHolder == null) {
            viewHolder = this.dataTypeViewHolderMapper.get(item.getClass().getName());
        }
        if (viewHolder != null) {
            if (this.viewTypeMapper.indexOfValue(viewHolder) < 0) {
                this.viewTypeMapper.put(this.identifier++, viewHolder);
            }
            for (int i = 0; i < this.viewTypeMapper.size(); ++i) {
                Class viewType = (Class)this.viewTypeMapper.get(i);
                if (!viewType.getName().equals(viewHolder.getName())) continue;
                return this.viewTypeMapper.keyAt(i);
            }
        }
        throw new RuntimeException(String.format("Fatal error! Mapping of ViewHolder to item '%s' does not exist", item.getClass().getName()));
    }

    public <VH extends SmartViewHolder> VH createViewHolder(HashMap<Class<? extends SmartViewHolder>, HashMap<Integer, HashMap<Integer, ViewEventListener>>> viewEventListeners, ViewGroup parent, int viewType) {
        SmartViewHolder viewHolder;
        Constructor constructor;
        Class smartViewHolderConstructor;
        try {
            smartViewHolderConstructor = (Class)this.viewTypeMapper.get(viewType);
            if (!this.viewHolderConstructorMapper.containsKey(smartViewHolderConstructor)) {
                Class[] classArray;
                if (ReflectionUtils.isNonStaticInnerClass(smartViewHolderConstructor)) {
                    Class[] classArray2 = new Class[2];
                    classArray2[0] = this.caller.getClass();
                    classArray = classArray2;
                    classArray2[1] = ViewGroup.class;
                } else {
                    Class[] classArray3 = new Class[1];
                    classArray = classArray3;
                    classArray3[0] = ViewGroup.class;
                }
                constructor = ReflectionUtils.getConstructor(smartViewHolderConstructor, classArray);
                this.viewHolderConstructorMapper.put(smartViewHolderConstructor, constructor);
            } else {
                constructor = this.viewHolderConstructorMapper.get(smartViewHolderConstructor);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(String.format("'%s' must have a constructor which take 'ViewGroup parent' as param or " + e.getMessage(), ((Class)this.viewTypeMapper.get(viewType)).toString()));
        }
        try {
            Object[] objectArray;
            if (ReflectionUtils.isNonStaticInnerClass(smartViewHolderConstructor)) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = this.caller;
                objectArray = objectArray2;
                objectArray2[1] = parent;
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = parent;
            }
            viewHolder = (SmartViewHolder)((Object)ReflectionUtils.invokeConstructor(smartViewHolderConstructor, constructor, objectArray));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(String.format("Error in '%s' constructor: " + e.getCause(), ((Class)this.viewTypeMapper.get(viewType)).toString()));
        }
        if (viewHolder instanceof ViewEventHolder) {
            ((ViewEventHolder)((Object)viewHolder)).setViewEventListeners(viewEventListeners.get(SmartViewHolder.class));
            ((ViewEventHolder)((Object)viewHolder)).setViewEventListeners(viewEventListeners.get(((Object)((Object)viewHolder)).getClass()));
        }
        if (viewHolder instanceof SmartAdapterHolder && this.smartRecyclerAdapterMapper.containsKey(((Object)((Object)viewHolder)).getClass())) {
            ((SmartAdapterHolder)((Object)viewHolder)).setSmartRecyclerAdapter(this.smartRecyclerAdapterMapper.get(((Object)((Object)viewHolder)).getClass()));
        }
        return (VH)((Object)viewHolder);
    }

    public void addMapping(Class<?> itemType, Class<? extends SmartViewHolder> viewHolderType) {
        this.dataTypeViewHolderMapper.put(itemType.getName(), viewHolderType);
    }

    public void setDataTypeViewHolderMapper(HashMap<String, Class<? extends SmartViewHolder>> dataTypeViewHolderMapper) {
        this.dataTypeViewHolderMapper = dataTypeViewHolderMapper;
    }

    public void setSmartRecyclerAdapterMapper(HashMap<Class<? extends SmartViewHolder>, SmartRecyclerAdapter> smartRecyclerAdapterMapper) {
        this.smartRecyclerAdapterMapper = smartRecyclerAdapterMapper;
    }
}

