/*
 * Decompiled with CFR 0.152.
 */
package com.wang.avi.indicators;

import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import com.wang.avi.Indicator;
import java.util.ArrayList;

public class BallDoubleBounceIndicator
extends Indicator {
    public static final float SCALE = 1.0f;
    private float[] scaleFloats = new float[]{1.0f, 1.0f};

    @Override
    public void draw(Canvas canvas, Paint paint) {
        float radius = (float)Math.min(this.getWidth(), this.getHeight()) / 2.5f;
        float centerX = (float)this.getWidth() / 2.0f;
        float centerY = (float)this.getHeight() / 2.0f;
        Paint ballPaint = new Paint(paint);
        ballPaint.setAlpha(153);
        for (int i = 0; i < 2; ++i) {
            canvas.save();
            canvas.translate(centerX, centerY);
            canvas.scale(this.scaleFloats[i], this.scaleFloats[i]);
            canvas.drawCircle(0.0f, 0.0f, radius, ballPaint);
            canvas.restore();
        }
    }

    @Override
    public ArrayList<ValueAnimator> onCreateAnimators() {
        ArrayList<ValueAnimator> animators = new ArrayList<ValueAnimator>();
        int[] delays = new int[]{0, 1000};
        for (int i = 0; i < 2; ++i) {
            final int index = i;
            ValueAnimator scaleAnim = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f, 1.0f});
            scaleAnim.setDuration(2000L);
            scaleAnim.setRepeatCount(-1);
            scaleAnim.setStartDelay((long)delays[i]);
            this.addUpdateListener(scaleAnim, new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    ((BallDoubleBounceIndicator)BallDoubleBounceIndicator.this).scaleFloats[index] = ((Float)animation.getAnimatedValue()).floatValue();
                    BallDoubleBounceIndicator.this.postInvalidate();
                }
            });
            animators.add(scaleAnim);
        }
        return animators;
    }
}

