/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.server.model.federation.edu.content;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.ma1uta.matrix.server.model.federation.edu.content.EphemeralDataUnitContent;
import io.github.ma1uta.matrix.server.model.federation.edu.content.nested.DeviceKeys;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.json.bind.annotation.JsonbProperty;

@Schema(description="Device list update.")
public class DeviceListUpdateContent
implements EphemeralDataUnitContent {
    @Schema(name="user_id", description="The user ID who owns this device.", required=true)
    @JsonbProperty(value="user_id")
    private String userId;
    @Schema(name="device_id", description="The ID of the device whose details are changing.", required=true)
    @JsonbProperty(value="device_id")
    private String deviceId;
    @Schema(name="device_display_name", description="The public human-readable name of this device. Will be absent if the device has no name.")
    @JsonbProperty(value="device_display_name")
    private String deviceDisplayName;
    @Schema(name="stream_id", description="An ID sent by the server for this update, unique for a given user_id. Used to identify any gaps in the sequence of m.device_list_update EDUs broadcast by a server.", required=true)
    @JsonbProperty(value="stream_id")
    private String streamId;
    @Schema(name="prev_id", description="The stream_ids of any prior m.device_list_update EDUs sent for this user which have not been referred to already in an EDU's prev_id field. If the receiving server does not recognise any of the prev_ids, it means an EDU has been lost and the server should query a snapshot of the device list via/user/keys/query in order to correctly interpret future m.device_list_update EDUs.May be missing or empty for the first EDU in a sequence.")
    @JsonbProperty(value="prev_id")
    private String prevId;
    @Schema(description="True if the server is announcing that this device has been deleted.")
    private Boolean deleted;
    @Schema(description="The updated identity keys (if any) for this device. May be absent if the device has no E2E keys defined.")
    private DeviceKeys keys;

    @JsonProperty(value="user_id")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @JsonProperty(value="device_id")
    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    @JsonProperty(value="device_displat_name")
    public String getDeviceDisplayName() {
        return this.deviceDisplayName;
    }

    public void setDeviceDisplayName(String deviceDisplayName) {
        this.deviceDisplayName = deviceDisplayName;
    }

    @JsonProperty(value="stream_id")
    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    @JsonProperty(value="prev_id")
    public String getPrevId() {
        return this.prevId;
    }

    public void setPrevId(String prevId) {
        this.prevId = prevId;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public DeviceKeys getKeys() {
        return this.keys;
    }

    public void setKeys(DeviceKeys keys) {
        this.keys = keys;
    }
}

