/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.support.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.github.ma1uta.matrix.event.Event;
import io.github.ma1uta.matrix.event.content.RoomEncryptedContent;
import io.github.ma1uta.matrix.event.content.RoomMessageContent;
import io.github.ma1uta.matrix.event.nested.ReceiptTs;
import io.github.ma1uta.matrix.support.jackson.EventDeserializer;
import io.github.ma1uta.matrix.support.jackson.ObjectMapperProvider;
import io.github.ma1uta.matrix.support.jackson.RoomEncryptedContentDeserializer;
import io.github.ma1uta.matrix.support.jackson.RoomMessageContentDeserializer;
import io.github.ma1uta.matrix.support.jackson.workaround.ReceiptTsDeserialized4898;

public class DefaultObjectMapperProvider
implements ObjectMapperProvider {
    private final ObjectMapper mapper = new ObjectMapper();

    public DefaultObjectMapperProvider() {
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        SimpleModule eventModule = new SimpleModule("Jackson Matrix Module");
        eventModule.addDeserializer(Event.class, (JsonDeserializer)new EventDeserializer());
        eventModule.addDeserializer(RoomEncryptedContent.class, (JsonDeserializer)new RoomEncryptedContentDeserializer());
        eventModule.addDeserializer(RoomMessageContent.class, (JsonDeserializer)new RoomMessageContentDeserializer());
        eventModule.addDeserializer(ReceiptTs.class, (JsonDeserializer)new ReceiptTsDeserialized4898());
        this.mapper.registerModule((Module)eventModule);
    }

    @Override
    public ObjectMapper get() {
        return this.mapper;
    }
}

