/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.identity.api;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.identity.model.associations.ValidationResponse;
import io.github.ma1uta.matrix.identity.model.session.EmailRequestToken;
import io.github.ma1uta.matrix.identity.model.session.PhoneRequestToken;
import io.github.ma1uta.matrix.identity.model.session.SubmitToken;
import io.github.ma1uta.matrix.thirdpid.SessionResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;

@Api(value="Session")
@Path(value="/_matrix/identity/api/v1")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface SessionApi {
    @ApiOperation(value="Create a session for validating an email address.", notes="The identity server will send an email containing a token. If that token is presented to the identity server in the future, it indicates that that user was able to read the email for that email address, and so we validate ownership of the email address.\nNote that homeservers offer APIs that proxy this API, adding additional behaviour on top, for example,/register/email/requestToken is designed specifically for use when registering an account and therefore will inform the user if the email address given is already registered on the server.", response=SessionResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Session created."), @ApiResponse(code=400, message="An error ocurred.")})
    @POST
    @Path(value="/validate/email/requestToken")
    public void createEmailSession(@ApiParam(value="JSON body request.") EmailRequestToken var1, @Context HttpServletRequest var2, @Suspended AsyncResponse var3);

    @ApiOperation(value="Validate ownership of an email address.", notes="If the three parameters are consistent with a set generated by a requestToken call, ownership of the email address is considered to have been validated. This does not publish any information publicly, or associate the email address with any Matrix user ID. Specifically, calls to /lookup will not show a binding.\nThe identity server is free to match the token case-insensitively, or carry out other mapping operations such as unicode normalisation. Whether to do so is an implementation detail for the identity server. Clients must always pass on the token without modification.", response=ValidationResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The success of the validation.")})
    @POST
    @Path(value="/validate/email/submitToken")
    public void postValidateEmail(@ApiParam(value="JSON body request.", required=true) SubmitToken var1, @Context HttpServletRequest var2, @Suspended AsyncResponse var3);

    @ApiOperation(value="Validate ownership of an email address.", notes="If the three parameters are consistent with a set generated by a requestToken call, ownership of the email address is considered to have been validated. This does not publish any information publicly, or associate the email address with any Matrix user ID. Specifically, calls to /lookup will not show a binding.\nThe identity server is free to match the token case-insensitively, or carry out other mapping operations such as unicode normalisation. Whether to do so is an implementation detail for the identity server. Clients must always pass on the token without modification.", response=EmptyResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Email address is validated."), @ApiResponse(code=302, message="Email address is validated, and the next_link parameter was provided to the requestToken call. The user must be redirected to the URL provided by the next_link parameter."), @ApiResponse(code=400, message="Validation failed.")})
    @GET
    @Path(value="/validate/email/submitToken")
    public void getValidateEmail(@ApiParam(value="The session ID, generated by the requestToken call.", required=true) @QueryParam(value="sid") String var1, @ApiParam(value="The client secret that was supplied to the requestToken call.", required=true) @QueryParam(value="client_secret") String var2, @ApiParam(value="The token generated by the requestToken call and emailed to the user.", required=true) @QueryParam(value="token") String var3, @Context HttpServletRequest var4, @Suspended AsyncResponse var5);

    @ApiOperation(value="Create a session for validating a phone number.", notes="The identity server will send an SMS message containing a token. If that token is presented to the identity server in the future, it indicates that that user was able to read the SMS for that phone number, and so we validate ownership of the phone number.\nNote that homeservers offer APIs that proxy this API, adding additional behaviour on top, for example, /register/msisdn/requestToken is designed specifically for use when registering an account and therefore will inform the user if the phone number given is already registered on the server.", response=SessionResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Session created."), @ApiResponse(code=400, message="An error occured.")})
    @POST
    @Path(value="/validate/msisdn/requestToken")
    public void createPhoneSession(@ApiParam(value="JSON body request", required=true) PhoneRequestToken var1, @Context HttpServletRequest var2, @Suspended AsyncResponse var3);

    @ApiOperation(value="Validate ownership of a phone number.", notes="If the three parameters are consistent with a set generated by a requestToken call, ownership of the email address is considered to have been validated. This does not publish any information publicly, or associate the email address with any Matrix user ID. Specifically, calls to /lookup will not show a binding.\nThe identity server is free to match the token case-insensitively, or carry out other mapping operations such as unicode normalisation. Whether to do so is an implementation detail for the identity server. Clients must always pass on the token without modification.", response=ValidationResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The success of the validation.")})
    @POST
    @Path(value="/validate/msisdn/submitToken")
    public void postValidatePhone(@ApiParam(value="JSON body request.", required=true) SubmitToken var1, @Context HttpServletRequest var2, @Suspended AsyncResponse var3);

    @ApiOperation(value="Validate ownership of an email address.", notes="If the three parameters are consistent with a set generated by a requestToken call, ownership of the email address is considered to have been validated. This does not publish any information publicly, or associate the email address with any Matrix user ID. Specifically, calls to /lookup will not show a binding.\nThe identity server is free to match the token case-insensitively, or carry out other mapping operations such as unicode normalisation. Whether to do so is an implementation detail for the identity server. Clients must always pass on the token without modification.\n Note: for backwards compatibility with previous drafts of this specification, the parameters may also be specifiedas application/x-form-www-urlencoded data. However, this usage is deprecated.", response=EmptyResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Phone number is validated."), @ApiResponse(code=302, message="Email address is validated, and the next_link parameter was provided to the requestToken call. The user must be redirected to the URL provided by the next_link parameter."), @ApiResponse(code=400, message="Validation failed.")})
    @GET
    @Path(value="/validate/msisdn/submitToken")
    public void getValidatePhone(@ApiParam(value="The session ID, generated by the requestToken call.", required=true) @QueryParam(value="sid") String var1, @ApiParam(value="The client secret that was supplied to the requestToken call.", required=true) @QueryParam(value="client_secret") String var2, @ApiParam(value="The token generated by the requestToken call and sent to the user.", required=true) @QueryParam(value="token") String var3, @Context HttpServletRequest var4, @Suspended AsyncResponse var5);
}

