/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.identity.api;

import io.github.ma1uta.matrix.common.EmptyResponse;
import io.github.ma1uta.matrix.common.ErrorResponse;
import io.github.ma1uta.matrix.identity.model.associations.ValidationResponse;
import io.github.ma1uta.matrix.identity.model.session.EmailRequestToken;
import io.github.ma1uta.matrix.identity.model.session.PhoneRequestToken;
import io.github.ma1uta.matrix.identity.model.session.SubmitToken;
import io.github.ma1uta.matrix.thirdpid.SessionResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;

@Path(value="/_matrix/identity/v2")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface SessionApi {
    @Operation(summary="Create a session for validating an email address.", description="The identity server will send an email containing a token. If that token is presented to the identity server in the future, it indicates that that user was able to read the email for that email address, and so we validate ownership of the email address.\nNote that homeservers offer APIs that proxy this API, adding additional behaviour on top, for example,/register/email/requestToken is designed specifically for use when registering an account and therefore will inform the user if the email address given is already registered on the server.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=SessionResponse.class))}), @ApiResponse(responseCode="200", description="Session created.", content={@Content(schema=@Schema(implementation=SessionResponse.class))}), @ApiResponse(responseCode="400", description="An error ocurred.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @Path(value="/validate/email/requestToken")
    public void createEmailSession(@RequestBody(description="JSON body request.") EmailRequestToken var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);

    @Operation(summary="Validate ownership of an email address.", description="If the three parameters are consistent with a set generated by a requestToken call, ownership of the email address is considered to have been validated. This does not publish any information publicly, or associate the email address with any Matrix user ID. Specifically, calls to /lookup will not show a binding.\nThe identity server is free to match the token case-insensitively, or carry out other mapping operations such as unicode normalisation. Whether to do so is an implementation detail for the identity server. Clients must always pass on the token without modification.", responses={@ApiResponse(responseCode="200", description="The success of the validation.", content={@Content(schema=@Schema(implementation=ValidationResponse.class))})})
    @POST
    @Path(value="/validate/email/submitToken")
    public void postValidateEmail(@RequestBody(description="JSON body request.", required=true) SubmitToken var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);

    @Operation(summary="Validate ownership of an email address.", description="If the three parameters are consistent with a set generated by a requestToken call, ownership of the email address is considered to have been validated. This does not publish any information publicly, or associate the email address with any Matrix user ID. Specifically, calls to /lookup will not show a binding.\nThe identity server is free to match the token case-insensitively, or carry out other mapping operations such as unicode normalisation. Whether to do so is an implementation detail for the identity server. Clients must always pass on the token without modification.", responses={@ApiResponse(responseCode="200", description="Email address is validated.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))}), @ApiResponse(responseCode="302", description="Email address is validated, and the next_link parameter was provided to the requestToken call. The user must be redirected to the URL provided by the next_link parameter.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="400", description="Validation failed.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/validate/email/submitToken")
    public void getValidateEmail(@Parameter(description="The session ID, generated by the requestToken call.", required=true) @QueryParam(value="sid") String var1, @Parameter(description="The client secret that was supplied to the requestToken call.", required=true) @QueryParam(value="client_secret") String var2, @Parameter(description="The token generated by the requestToken call and emailed to the user.", required=true) @QueryParam(value="token") String var3, @Context UriInfo var4, @Context HttpHeaders var5, @Suspended AsyncResponse var6, @Context SecurityContext var7);

    @Operation(summary="Create a session for validating a phone number.", description="The identity server will send an SMS message containing a token. If that token is presented to the identity server in the future, it indicates that that user was able to read the SMS for that phone number, and so we validate ownership of the phone number.\nNote that homeservers offer APIs that proxy this API, adding additional behaviour on top, for example, /register/msisdn/requestToken is designed specifically for use when registering an account and therefore will inform the user if the phone number given is already registered on the server.", responses={@ApiResponse(responseCode="200", description="Session created.", content={@Content(schema=@Schema(implementation=SessionResponse.class))}), @ApiResponse(responseCode="400", description="An error occured.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @Path(value="/validate/msisdn/requestToken")
    public void createPhoneSession(@RequestBody(description="JSON body request", required=true) PhoneRequestToken var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);

    @Operation(summary="Validate ownership of a phone number.", description="If the three parameters are consistent with a set generated by a requestToken call, ownership of the email address is considered to have been validated. This does not publish any information publicly, or associate the email address with any Matrix user ID. Specifically, calls to /lookup will not show a binding.\nThe identity server is free to match the token case-insensitively, or carry out other mapping operations such as unicode normalisation. Whether to do so is an implementation detail for the identity server. Clients must always pass on the token without modification.", responses={@ApiResponse(responseCode="200", description="The success of the validation.", content={@Content(schema=@Schema(implementation=ValidationResponse.class))})})
    @POST
    @Path(value="/validate/msisdn/submitToken")
    public void postValidatePhone(@RequestBody(description="JSON body request.", required=true) SubmitToken var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);

    @Operation(summary="Validate ownership of an email address.", description="If the three parameters are consistent with a set generated by a requestToken call, ownership of the email address is considered to have been validated. This does not publish any information publicly, or associate the email address with any Matrix user ID. Specifically, calls to /lookup will not show a binding.\nThe identity server is free to match the token case-insensitively, or carry out other mapping operations such as unicode normalisation. Whether to do so is an implementation detail for the identity server. Clients must always pass on the token without modification.\n Note: for backwards compatibility with previous drafts of this specification, the parameters may also be specifiedas application/x-form-www-urlencoded data. However, this usage is deprecated.", responses={@ApiResponse(responseCode="200", description="Phone number is validated.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))}), @ApiResponse(responseCode="302", description="Email address is validated, and the next_link parameter was provided to the requestToken call. The user must be redirected to the URL provided by the next_link parameter.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="400", description="Validation failed.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/validate/msisdn/submitToken")
    public void getValidatePhone(@Parameter(description="The session ID, generated by the requestToken call.", required=true) @QueryParam(value="sid") String var1, @Parameter(description="The client secret that was supplied to the requestToken call.", required=true) @QueryParam(value="client_secret") String var2, @Parameter(description="The token generated by the requestToken call and sent to the user.", required=true) @QueryParam(value="token") String var3, @Context UriInfo var4, @Context HttpHeaders var5, @Suspended AsyncResponse var6, @Context SecurityContext var7);
}

