/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.identity.api;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.ErrorResponse;
import io.github.ma1uta.matrix.identity.model.validation.PublishRequest;
import io.github.ma1uta.matrix.identity.model.validation.PublishResponse;
import io.github.ma1uta.matrix.identity.model.validation.UnbindRequest;
import io.github.ma1uta.matrix.identity.model.validation.ValidationResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;

@Path(value="/_matrix/identity/v2")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface ValidationApi {
    @Operation(summary="Determines if a given 3pid has been validated by a user.", responses={@ApiResponse(responseCode="200", description="Validation information for the session.", content={@Content(schema=@Schema(implementation=ValidationResponse.class))}), @ApiResponse(responseCode="400", description="he session has not been validated. If the session has not been validated, then errcode will be M_SESSION_NOT_VALIDATED. If the session has timed out, then errcode will be M_SESSION_EXPIRED.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="The Session ID or client secret were not found.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/3pid/getValidated3pid")
    public void validate(@Parameter(description="The Session ID generated by the requestToken call.", required=true) @QueryParam(value="sid") String var1, @Parameter(description="The client secret passed to the requestToken call.", required=true) @QueryParam(value="client_secret") String var2, @Context UriInfo var3, @Context HttpHeaders var4, @Suspended AsyncResponse var5, @Context SecurityContext var6);

    @Operation(summary="Publish an association between a session and a Matrix user ID.", description="Future calls to /lookup for any of the session's 3pids will return this association.", responses={@ApiResponse(responseCode="200", description="The association was published.", content={@Content(schema=@Schema(implementation=PublishResponse.class))}), @ApiResponse(responseCode="400", description="The association was not published. If the session has not been validated, then errcode will be M_SESSION_NOT_VALIDATED. If the session has timed out, then errcode will be M_SESSION_EXPIRED.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="he Session ID or client secret were not found.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @Path(value="/bind")
    public void bind(@RequestBody(description="JSON body request", required=true) PublishRequest var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);

    @Operation(summary="Remove an association between a session and a Matrix user ID.", description="Future calls to /lookup for any of the session's 3pids will not return the removed association.", responses={@ApiResponse(responseCode="200", description="The association was successfully removed.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))}), @ApiResponse(responseCode="400", description="If the response body is not a JSON Matrix error, the identity server does not support unbinds. If a JSON Matrix error is in the response body, the requesting party should respect the error.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="The credentials supplied to authenticate the request were invalid. This may also be returned if the identity server does not support the chosen authentication method(such as blocking homeservers from unbinding identifiers).", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="If the response body is not a JSON Matrix error, the identity server does not support unbinds. If a JSON Matrix error is in the response body, the requesting party should respect the error.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="501", description="If the response body is not a JSON Matrix error, the identity server does not support unbinds. If a JSON Matrix error is in the response body, the requesting party should respect the error.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @POST
    @Path(value="/unbind")
    public void unbind(@RequestBody(description="JSON body request", required=true) UnbindRequest var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);
}

