/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.identity.model.lookup;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import javax.json.bind.annotation.JsonbProperty;

@Schema(description="Look up response the Matrix user ID for a 3pid.")
public class SingleLookupResponse {
    @Schema(description="The 3pid address of the user being looked up, matching the address requested.", required=true)
    private String address;
    @Schema(description="A medium from the 3PID Types Appendix, matching the medium requested.", required=true)
    private String medium;
    @Schema(description="The Matrix user ID associated with the 3pid.", required=true)
    private String mxid;
    @Schema(name="not_before", description="A unix timestamp before which the association is not known to be valid.", required=true)
    @JsonbProperty(value="not_before")
    private Long notBefore;
    @Schema(name="not_after", description="A unix timestamp after which the association is not known to be valid.", required=true)
    @JsonbProperty(value="not_after")
    private Long notAfter;
    @Schema(description="The unix timestamp at which the association was verified.", required=true)
    private Long ts;
    @Schema(description="The signatures of the verifying identity services which show that the association should be trusted, if you trust the verifying identity services.", required=true)
    private Map<String, Map<String, String>> signatures;

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getMedium() {
        return this.medium;
    }

    public void setMedium(String medium) {
        this.medium = medium;
    }

    public String getMxid() {
        return this.mxid;
    }

    public void setMxid(String mxid) {
        this.mxid = mxid;
    }

    @JsonProperty(value="not_before")
    public Long getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(Long notBefore) {
        this.notBefore = notBefore;
    }

    @JsonProperty(value="not_after")
    public Long getNotAfter() {
        return this.notAfter;
    }

    public void setNotAfter(Long notAfter) {
        this.notAfter = notAfter;
    }

    public Long getTs() {
        return this.ts;
    }

    public void setTs(Long ts) {
        this.ts = ts;
    }

    public Map<String, Map<String, String>> getSignatures() {
        return this.signatures;
    }

    public void setSignatures(Map<String, Map<String, String>> signatures) {
        this.signatures = signatures;
    }
}

