/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.impl.exception;

import io.github.ma1uta.matrix.common.ErrorResponse;
import io.github.ma1uta.matrix.common.ExceptionResponse;
import io.github.ma1uta.matrix.impl.exception.MatrixException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionHandler
implements ExceptionMapper<Throwable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionHandler.class);

    public Response toResponse(Throwable exception) {
        Integer status;
        ExceptionResponse message;
        LOGGER.error("Exception:", exception);
        if (exception instanceof MatrixException) {
            MatrixException matrixException = (MatrixException)exception;
            message = matrixException.getResponse();
            status = matrixException.getStatus();
        } else {
            message = this.message(exception);
            status = 500;
        }
        return Response.status((int)status).entity((Object)message).build();
    }

    protected ErrorResponse message(Throwable throwable) {
        return new ErrorResponse("M_INTERNAL", throwable.getMessage());
    }
}

