/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.event.content;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.ma1uta.matrix.event.content.EventContent;
import io.github.ma1uta.matrix.event.encrypted.MegolmEncryptedContent;
import io.github.ma1uta.matrix.event.encrypted.OlmEncryptedContent;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.json.bind.annotation.JsonbProperty;

@Schema(description="This event type is used when sending encrypted events. It can be used either within a room (in which case it will have all of the Room Event fields), or as a to-device event.", subTypes={MegolmEncryptedContent.class, OlmEncryptedContent.class})
public abstract class RoomEncryptedContent
implements EventContent {
    @Schema(name="sender_key", description="The Curve25519 key of the sender.", required=true)
    @JsonbProperty(value="sender_key")
    private String senderKey;
    @Schema(name="device_id", description="The ID of the sending device. Required with Megolm.")
    @JsonbProperty(value="device_id")
    private String deviceId;
    @Schema(name="session_id", description="The ID of the session used to encrypt the message. Required with Megolm.")
    @JsonbProperty(value="session_id")
    private String sessionId;

    @Schema(name="algorithm", description="The encryption algorithm used to encrypt this event. The value of this field determines which other properties will be present.", required=true, allowableValues={"m.olm.v1.curve25519-aes-sha2, m.megolm.v1.aes-sha2"})
    @JsonbProperty(value="algorithm")
    public abstract String getAlgorithm();

    @JsonProperty(value="sender_key")
    public String getSenderKey() {
        return this.senderKey;
    }

    public void setSenderKey(String senderKey) {
        this.senderKey = senderKey;
    }

    @JsonProperty(value="device_id")
    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    @JsonProperty(value="session_id")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }
}

