/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.event.content;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.ma1uta.matrix.Id;
import io.github.ma1uta.matrix.event.content.EventContent;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import javax.json.bind.annotation.JsonbProperty;

@Schema(description="This event type is used to forward keys for end-to-end encryption. Typically it is encrypted as an m.room.encrypted event, then sent as a to-device event.")
public class ForwardedRoomKeyContent
implements EventContent {
    @Schema(description="Required. The encryption algorithm the key in this event is to be used with.", required=true)
    private String algorithm;
    @Schema(name="room_id", description="The room where the key is used.", required=true)
    @JsonbProperty(value="room_id")
    private Id roomId;
    @Schema(name="sender_key", description="Required. The Curve25519 key of the device which initiated the session originally.", required=true)
    @JsonbProperty(value="sender_key")
    private String senderKey;
    @Schema(name="session_id", description="The ID of the session that the key is for.", required=true)
    @JsonbProperty(value="session_id")
    private String sessionId;
    @Schema(name="session_key", description="The key to be exchanged.", required=true)
    @JsonbProperty(value="session_key")
    private String sessionKey;
    @Schema(name="sender_claimed_ed25519_key", description="The Ed25519 key of the device which initiated the session originally. It is 'claimed' because the receiving device has no way to tell that the original room_key actually came from a device which owns the private partof this key unless they have done device verification.", required=true)
    @JsonbProperty(value="sender_claimed_ed25519_key")
    private String senderClaimedEd25519Key;
    @Schema(name="forwarding_curve25519_key_chain", description="Chain of Curve25519 keys. It starts out empty, but each time the key is forwarded to another device, the previous sender in the chain is added to the end of the list. For example, if the key is forwarded from A to B to C, this field is empty between A and B, and contains A's Curve25519 key between B and C.", required=true)
    @JsonbProperty(value="forwarding_curve25519_key_chain")
    private List<String> forwardingCurve25519KeyChain;

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    @JsonProperty(value="room_id")
    public Id getRoomId() {
        return this.roomId;
    }

    public void setRoomId(Id roomId) {
        this.roomId = roomId;
    }

    @JsonProperty(value="sender_key")
    public String getSenderKey() {
        return this.senderKey;
    }

    public void setSenderKey(String senderKey) {
        this.senderKey = senderKey;
    }

    @JsonProperty(value="session_id")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @JsonProperty(value="session_key")
    public String getSessionKey() {
        return this.sessionKey;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    @JsonProperty(value="sender_claimed_ed25219_key")
    public String getSenderClaimedEd25519Key() {
        return this.senderClaimedEd25519Key;
    }

    public void setSenderClaimedEd25519Key(String senderClaimedEd25519Key) {
        this.senderClaimedEd25519Key = senderClaimedEd25519Key;
    }

    @JsonProperty(value="forwarding_curve_25519_key_chain")
    public List<String> getForwardingCurve25519KeyChain() {
        return this.forwardingCurve25519KeyChain;
    }

    public void setForwardingCurve25519KeyChain(List<String> forwardingCurve25519KeyChain) {
        this.forwardingCurve25519KeyChain = forwardingCurve25519KeyChain;
    }
}

