/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.regex.Matcher;

public abstract class Id {
    private static Id instance;
    private static final String DEFAULT_PROVIDER = "io.github.ma1uta.matrix.MatrixId";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Id getInstance() {
        if (instance != null) return instance;
        String string = DEFAULT_PROVIDER;
        synchronized (DEFAULT_PROVIDER) {
            if (instance != null) return instance;
            ServiceLoader<Id> serviceLoader = ServiceLoader.load(Id.class);
            Iterator<Id> iterator = serviceLoader.iterator();
            if (iterator.hasNext()) {
                instance = iterator.next();
            } else {
                try {
                    instance = AccessController.doPrivileged(() -> (Id)Class.forName(DEFAULT_PROVIDER).newInstance());
                }
                catch (PrivilegedActionException e) {
                    throw new RuntimeException("Failed load the default implementation. Please check that the common-sdk jar available", e);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected Id() {
    }

    public boolean isId(String id) {
        try {
            this.validate(id);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    protected abstract Matcher validate(String var1);

    public char sigil(String id) {
        this.validate(id);
        return id.charAt(0);
    }

    public String localpart(String id) {
        return this.validate(id).group(1);
    }

    public String domain(String id) {
        return this.validate(id).group(2);
    }

    public boolean isUserId(String id) {
        try {
            Matcher matcher = this.validate(id);
            return id.charAt(0) == '@' && this.userMatchers(matcher);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    protected abstract boolean userMatchers(Matcher var1);

    public boolean isEventId(String id) {
        try {
            Matcher matcher = this.validate(id);
            return id.charAt(0) == '$' && this.eventMatchers(matcher);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    protected abstract boolean eventMatchers(Matcher var1);

    public boolean isRoomId(String id) {
        try {
            Matcher matcher = this.validate(id);
            return id.charAt(0) == '!' && this.roomMatchers(matcher);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    protected abstract boolean roomMatchers(Matcher var1);

    public boolean isAliasId(String id) {
        try {
            Matcher matcher = this.validate(id);
            return id.charAt(0) == '#' && this.aliasMatchers(matcher);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    protected abstract boolean aliasMatchers(Matcher var1);

    public boolean isGroupId(String id) {
        try {
            Matcher matcher = this.validate(id);
            return id.charAt(0) == '+' && this.groupMatchers(matcher);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    protected abstract boolean groupMatchers(Matcher var1);

    public static class Sigil {
        public static final char EVENT = '$';
        public static final char USER = '@';
        public static final char ROOM = '!';
        public static final char ALIAS = '#';
        public static final char GROUP = '+';

        protected Sigil() {
        }
    }
}

