/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Id {
    private static final Logger LOGGER = LoggerFactory.getLogger(Id.class);
    public static final Pattern PATTERN = Pattern.compile("^[@!$#+]([^:]+):(.+)$");
    public static final Pattern USER = Pattern.compile("[a-z0-9._=\\-/]+");
    public static final Pattern DOMAIN = Pattern.compile("(\\d{3}.\\d{3}.\\d{3}.\\d{3}|\\[[0-9\\p{Alpha}:]{0,39}]|[0-9\\-.\\p{Alpha}]{1,255})(:[\\d]+)?");

    protected Id() {
    }

    public static boolean isId(String id) {
        try {
            Id.validate(id);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static Matcher validate(String id) {
        if (id == null || id.trim().isEmpty()) {
            String message = "Empty id";
            LOGGER.error(message);
            throw new IllegalArgumentException(message);
        }
        Matcher matcher = PATTERN.matcher(id.trim());
        if (!matcher.matches()) {
            String message = String.format("Invalid id: '%s'", id);
            LOGGER.error(message);
            throw new IllegalArgumentException(message);
        }
        String localpart = matcher.group(1);
        String domain = matcher.group(2);
        LOGGER.trace("localpart: '%s', domain: '%s'", (Object)localpart, (Object)domain);
        Matcher domainMatcher = DOMAIN.matcher(domain);
        if (!domainMatcher.matches()) {
            String message = String.format("Invalid domain part: '%s'", domain);
            LOGGER.error(message);
            throw new IllegalArgumentException(message);
        }
        return matcher;
    }

    public static char sigil(String id) {
        Id.validate(id);
        return id.charAt(0);
    }

    public static String localpart(String id) {
        return Id.validate(id).group(1);
    }

    public static String domain(String id) {
        return Id.validate(id).group(2);
    }

    public static boolean isUserId(String id) {
        try {
            Matcher matcher = Id.validate(id);
            return id.charAt(0) == '@' && USER.matcher(matcher.group(1)).matches();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isEventId(String id) {
        try {
            return Id.sigil(id) == '$';
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isRoomId(String id) {
        try {
            return Id.sigil(id) == '!';
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isAliasId(String id) {
        try {
            return Id.sigil(id) == '#';
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isGroupId(String id) {
        try {
            return Id.sigil(id) == '+';
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static class Sigil {
        public static final char EVENT = '$';
        public static final char USER = '@';
        public static final char ROOM = '!';
        public static final char ALIAS = '#';
        public static final char GROUP = '+';

        protected Sigil() {
        }
    }
}

