/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import io.github.ma1uta.matrix.events.RoomMessage;
import io.github.ma1uta.matrix.events.messages.Audio;
import io.github.ma1uta.matrix.events.messages.Emote;
import io.github.ma1uta.matrix.events.messages.File;
import io.github.ma1uta.matrix.events.messages.Image;
import io.github.ma1uta.matrix.events.messages.Location;
import io.github.ma1uta.matrix.events.messages.Notice;
import io.github.ma1uta.matrix.events.messages.RawMessage;
import io.github.ma1uta.matrix.events.messages.Text;
import io.github.ma1uta.matrix.events.messages.Video;

public class RoomMessageDeserializer {
    public RoomMessage deserialize(JsonNode node, ObjectCodec codec) throws JsonProcessingException {
        String msgtype;
        if (node == null) {
            return null;
        }
        JsonNode typeNode = node.get("msgtype");
        if (typeNode == null || !typeNode.isTextual()) {
            return new RawMessage(node, null);
        }
        switch (msgtype = typeNode.asText()) {
            case "m.audio": {
                return (RoomMessage)codec.treeToValue((TreeNode)node, Audio.class);
            }
            case "m.emote": {
                return (RoomMessage)codec.treeToValue((TreeNode)node, Emote.class);
            }
            case "m.file": {
                return (RoomMessage)codec.treeToValue((TreeNode)node, File.class);
            }
            case "m.image": {
                return (RoomMessage)codec.treeToValue((TreeNode)node, Image.class);
            }
            case "m.location": {
                return (RoomMessage)codec.treeToValue((TreeNode)node, Location.class);
            }
            case "m.notice": {
                return (RoomMessage)codec.treeToValue((TreeNode)node, Notice.class);
            }
            case "m.text": {
                return (RoomMessage)codec.treeToValue((TreeNode)node, Text.class);
            }
            case "m.video": {
                return (RoomMessage)codec.treeToValue((TreeNode)node, Video.class);
            }
        }
        return new RawMessage(node, msgtype);
    }
}

