/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.event.content;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.ma1uta.matrix.event.content.EventContent;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.json.bind.annotation.JsonbProperty;

@Schema(description="This event type is used to exchange keys for end-to-end encryption. Typically it is encrypted as an m.room.encrypted event, then sent as a to-device event.")
public class RoomKeyContent
implements EventContent {
    @Schema(description="The encryption algorithm the key in this event is to be used with. Must be 'm.megolm.v1.aes-sha2'.", required=true)
    private String algorithm;
    @Schema(name="room_id", description="The room where the key is used.", required=true)
    @JsonbProperty(value="room_id")
    private String roomId;
    @Schema(name="session_id", description="The ID of the session that the key is for.", required=true)
    @JsonbProperty(value="session_id")
    private String sessionId;
    @Schema(name="session_key", description="The key to be exchanged.", required=true)
    @JsonbProperty(value="session_key")
    private String sessionKey;

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    @JsonProperty(value="room_id")
    public String getRoomId() {
        return this.roomId;
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    @JsonProperty(value="session_id")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @JsonProperty(value="session_key")
    public String getSessionKey() {
        return this.sessionKey;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }
}

