/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.event.content;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.ma1uta.matrix.event.content.EventContent;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.json.bind.annotation.JsonbProperty;

@Schema(description="Sent by either party to signal their termination of the call. This can be sent either once the call has has been established or before to abort the call.")
public class CallHangupContent
implements EventContent {
    @Schema(description="The ID of the call this event relates to.", required=true)
    @JsonbProperty(value="call_id")
    private String callId;
    @Schema(description="The version of the VoIP specification this message adheres to. This specification is version 0.", required=true)
    private Long version;
    @Schema(description="Optional error reason for the hangup. This should not be provided when the user naturally ends or rejects the call. When there was an error in the call negotiation, this should be ice_failed for when ICE negotiation fails or invite_timeout for when the other party did not answer in time.", allowableValues={"ice_failed", "invite_timeout"})
    private String reason;

    @JsonProperty(value="call_id")
    public String getCallId() {
        return this.callId;
    }

    public void setCallId(String callId) {
        this.callId = callId;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public static class Reason {
        public static final String ICE_FAILED = "ice_failed";
        public static final String INVITE_TIMEOUT = "invite_timeout";

        protected Reason() {
        }
    }
}

