/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.event.content;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.ma1uta.matrix.event.Unsigned;
import io.github.ma1uta.matrix.event.content.EventContent;
import io.github.ma1uta.matrix.event.nested.Invite;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.json.bind.annotation.JsonbProperty;

@Schema(description="Adjusts the membership state for a user in a room. It is preferable to use the membership APIs (/rooms/<room id>/invite etc) when performing membership actions rather than adjusting the state directly as there are a restricted set of valid transformations. For example, user A cannot force user B to join a room, and trying to force this state change directly will fail.")
public class RoomMemberContent
implements EventContent {
    public static final String INVITE = "invite";
    public static final String JOIN = "join";
    public static final String LEAVE = "leave";
    public static final String BAN = "ban";
    public static final String KNOCK = "knock";
    @Schema(name="avatar_url", description="The avatar URL for this user, if any. This is added by the homeserver.")
    @JsonbProperty(value="avatar_url")
    private String avatarUrl;
    @Schema(name="displayname", description="The display name for this user, if any. This is added by the homeserver.")
    @JsonbProperty(value="displayname")
    private String displayName;
    @Schema(description="The membership state of the user.", required=true, allowableValues={"invite, join, knock, leave, ban"})
    private String membership;
    @Schema(name="is_direct", description="Flag indicating if the room containing this event was created with the intention of being a direct chat. See Direct Messaging.")
    @JsonbProperty(value="is_direct")
    private Boolean isDirect;
    @Schema(name="third_party_invite", description="Third-party invites.")
    @JsonbProperty(value="third_party_invite")
    private Invite thirdPartyInvite;
    @Schema(description="Contains optional extra information about the event.")
    private Unsigned unsigned;

    @JsonProperty(value="avatar_url")
    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    @JsonProperty(value="displayname")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getMembership() {
        return this.membership;
    }

    public void setMembership(String membership) {
        this.membership = membership;
    }

    @JsonProperty(value="is_direct")
    public Boolean getDirect() {
        return this.isDirect;
    }

    public void setDirect(Boolean direct) {
        this.isDirect = direct;
    }

    @JsonProperty(value="third_party_invite")
    public Invite getThirdPartyInvite() {
        return this.thirdPartyInvite;
    }

    public void setThirdPartyInvite(Invite thirdPartyInvite) {
        this.thirdPartyInvite = thirdPartyInvite;
    }

    public Unsigned getUnsigned() {
        return this.unsigned;
    }

    public void setUnsigned(Unsigned unsigned) {
        this.unsigned = unsigned;
    }
}

