/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.event.content;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.ma1uta.matrix.event.content.EventContent;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.json.bind.annotation.JsonbProperty;

@Schema(description="Accepts a previously sent m.key.verification.start message. Typically sent as a to-device event.")
public class KeyVerificationAcceptContent
implements EventContent {
    @Schema(name="transaction_id", description="An opaque identifier for the verification process. Must be the same as the one used for the m.key.verification.start message.", required=true)
    @JsonbProperty(value="transaction_id")
    private String transactionId;
    @Schema(description="The verification method to use. Must be 'm.sas.v1'.", required=true)
    private String method;
    @Schema(name="key_agreement_protocol", description="The key agreement protocol the device is choosing to use, out of the options in the m.key.verification.start message.", required=true)
    @JsonbProperty(value="key_agreement_protocol")
    private String keyAgreementProtocol;
    @Schema(description="The hash method the device is choosing to use, out of the options in the m.key.verification.start message.", required=true)
    private String hash;
    @Schema(name="message_authentication_code", description="The message authentication code the device is choosing to use, out of the options in the m.key.verification.start message.", required=true)
    @JsonbProperty(value="message_authentication_code")
    private String messageAuthenticationCode;
    @Schema(name="short_authentication_string", description="The SAS methods both devices involved in the verification process understand. Must be a subset of the options in the m.key.verification.start message.", required=true, allowableValues={"decimal", "emoji"})
    @JsonbProperty(value="short_authentication_string")
    private String shortAuthenticationString;
    @Schema(description="The hash (encoded as unpadded base64) of the concatenation of the device's ephemeral public key (encoded as unpadded base64) and the canonical JSON representation of the m.key.verification.start message.", required=true)
    private String commitment;

    @JsonProperty(value="transaction_id")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    @JsonProperty(value="key_agreement_protocol")
    public String getKeyAgreementProtocol() {
        return this.keyAgreementProtocol;
    }

    public void setKeyAgreementProtocol(String keyAgreementProtocol) {
        this.keyAgreementProtocol = keyAgreementProtocol;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    @JsonProperty(value="message_authentication_code")
    public String getMessageAuthenticationCode() {
        return this.messageAuthenticationCode;
    }

    public void setMessageAuthenticationCode(String messageAuthenticationCode) {
        this.messageAuthenticationCode = messageAuthenticationCode;
    }

    @JsonProperty(value="short_authentication_string")
    public String getShortAuthenticationString() {
        return this.shortAuthenticationString;
    }

    public void setShortAuthenticationString(String shortAuthenticationString) {
        this.shortAuthenticationString = shortAuthenticationString;
    }

    public String getCommitment() {
        return this.commitment;
    }

    public void setCommitment(String commitment) {
        this.commitment = commitment;
    }
}

