/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.Id;
import io.github.ma1uta.matrix.client.RequestParams;
import io.github.ma1uta.matrix.client.api.ReportApi;
import io.github.ma1uta.matrix.client.factory.RequestFactory;
import io.github.ma1uta.matrix.client.methods.AbstractMethods;
import io.github.ma1uta.matrix.client.model.report.ReportRequest;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class ReportMethods
extends AbstractMethods {
    public ReportMethods(RequestFactory factory, RequestParams defaultParams) {
        super(factory, defaultParams);
    }

    public CompletableFuture<EmptyResponse> report(Id roomId, Id eventId, String reason, Integer score) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(eventId, "EventId cannot be empty.");
        Objects.requireNonNull(reason, "Reason cannot be empty.");
        Objects.requireNonNull(score, "Score cannot be empty.");
        RequestParams params = this.defaults().clone().path("roomId", roomId.toString()).path("eventId", eventId.toString());
        ReportRequest request = new ReportRequest();
        request.setReason(reason);
        request.setScore(score);
        return this.factory().post(ReportApi.class, "report", params, reason, EmptyResponse.class);
    }
}

